/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.mkui.geom.Rectangle2D;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001\u0018B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u0010\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/macrofocus/plot/guide/RectangleInsets;", "", "top", "", "left", "bottom", "right", "(DDDD)V", "getBottom", "()D", "getLeft", "getRight", "getTop", "unitType", "Lcom/macrofocus/plot/guide/RectangleInsets$UnitType;", "calculateBottomOutset", "height", "calculateLeftOutset", "width", "calculateRightOutset", "calculateTopOutset", "createOutsetRectangle", "Lorg/mkui/geom/Rectangle2D;", "base", "UnitType", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class RectangleInsets {
    @NotNull
    private final UnitType unitType = UnitType.Absolute;
    private final double top;
    private final double left;
    private final double bottom;
    private final double right;
    public static final int $stable;

    public RectangleInsets(double top, double left, double bottom, double right) {
        this.top = top;
        this.bottom = bottom;
        this.left = left;
        this.right = right;
    }

    public final double getTop() {
        return this.top;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getRight() {
        return this.right;
    }

    @NotNull
    public final Rectangle2D createOutsetRectangle(@NotNull Rectangle2D base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        double topMargin = 0.0;
        double bottomMargin = 0.0;
        topMargin = this.calculateTopOutset(base.getHeight());
        bottomMargin = this.calculateBottomOutset(base.getHeight());
        double leftMargin = 0.0;
        double rightMargin = 0.0;
        leftMargin = this.calculateLeftOutset(base.getWidth());
        rightMargin = this.calculateRightOutset(base.getWidth());
        return (Rectangle2D)new Rectangle2D.Double(base.getX() - leftMargin, base.getY() - topMargin, base.getWidth() + leftMargin + rightMargin, base.getHeight() + topMargin + bottomMargin);
    }

    private final double calculateTopOutset(double height) {
        double result = this.top;
        if (this.unitType == UnitType.Relative) {
            result = height / (1.0 - this.top - this.bottom) * this.top;
        }
        return result;
    }

    private final double calculateBottomOutset(double height) {
        double result = this.bottom;
        if (this.unitType == UnitType.Relative) {
            result = height / (1.0 - this.top - this.bottom) * this.bottom;
        }
        return result;
    }

    private final double calculateLeftOutset(double width) {
        double result = this.left;
        if (this.unitType == UnitType.Relative) {
            result = width / (1.0 - this.left - this.right) * this.left;
        }
        return result;
    }

    private final double calculateRightOutset(double width) {
        double result = this.right;
        if (this.unitType == UnitType.Relative) {
            result = width / (1.0 - this.left - this.right) * this.right;
        }
        return result;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcom/macrofocus/plot/guide/RectangleInsets$UnitType;", "", "(Ljava/lang/String;I)V", "Absolute", "Relative", "macrofocus-slider"})
    public static final class UnitType
    extends Enum<UnitType> {
        public static final /* enum */ UnitType Absolute = new UnitType();
        public static final /* enum */ UnitType Relative = new UnitType();
        private static final /* synthetic */ UnitType[] $VALUES;

        public static UnitType[] values() {
            return (UnitType[])$VALUES.clone();
        }

        public static UnitType valueOf(String value) {
            return Enum.valueOf(UnitType.class, value);
        }

        static {
            $VALUES = unitTypeArray = new UnitType[]{UnitType.Absolute, UnitType.Relative};
        }
    }
}

