/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import com.macrofocus.common.format.CPFormat;
import com.macrofocus.common.format.FormatFactory;
import com.macrofocus.plot.guide.NumberTickUnit;
import com.macrofocus.plot.guide.TickUnit;
import com.macrofocus.plot.guide.TickUnitSource;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0007J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/macrofocus/plot/guide/TickUnits;", "Lcom/macrofocus/plot/guide/TickUnitSource;", "formatFactory", "Lcom/macrofocus/common/format/FormatFactory;", "(Lcom/macrofocus/common/format/FormatFactory;)V", "tickUnits", "", "Lcom/macrofocus/plot/guide/TickUnit;", "add", "", "unit", "getCeilingTickUnit", "size", "", "getLargerTickUnit", "macrofocus-slider"})
public final class TickUnits
implements TickUnitSource {
    @NotNull
    private final FormatFactory formatFactory;
    @NotNull
    private final List<TickUnit> tickUnits;

    public TickUnits(@NotNull FormatFactory formatFactory) {
        Intrinsics.checkNotNullParameter((Object)formatFactory, (String)"formatFactory");
        this.formatFactory = formatFactory;
        this.tickUnits = new ArrayList();
    }

    public final void add(@NotNull TickUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        this.tickUnits.add(unit);
        CollectionsKt.sort(this.tickUnits);
    }

    @Override
    @NotNull
    public TickUnit getLargerTickUnit(@NotNull TickUnit unit) {
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        int index = CollectionsKt.binarySearch$default(this.tickUnits, (Comparable)unit, (int)0, (int)0, (int)6, null);
        return this.tickUnits.get(Math.min(index += index >= 0 ? 1 : -index, this.tickUnits.size() - 1));
    }

    @Override
    @NotNull
    public TickUnit getCeilingTickUnit(@NotNull TickUnit unit) {
        TickUnit tickUnit;
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        int index = CollectionsKt.binarySearch$default(this.tickUnits, (Comparable)unit, (int)0, (int)0, (int)6, null);
        if (index >= 0) {
            tickUnit = this.tickUnits.get(index);
        } else {
            index = -(index + 1);
            tickUnit = this.tickUnits.get(Math.min(index, this.tickUnits.size() - 1));
        }
        return tickUnit;
    }

    @Override
    @NotNull
    public TickUnit getCeilingTickUnit(double size) {
        return this.getCeilingTickUnit(new NumberTickUnit(size, (CPFormat<Object>)this.formatFactory.createDecimalFormat()));
    }
}

