/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.plot.guide;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.format.CPFormat;
import com.macrofocus.plot.guide.AbstractAxis;
import com.macrofocus.plot.guide.AxisSpace;
import com.macrofocus.plot.guide.Range;
import com.macrofocus.plot.guide.RectangleEdge;
import com.macrofocus.plot.guide.RectangleInsets;
import com.macrofocus.plot.guide.Tick;
import com.macrofocus.plot.guide.TickUnitSource;
import com.macrofocus.plot.guide.ValueTick;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.font.CPFontFactory;
import org.mkui.geom.Polygon;
import org.mkui.geom.Rectangle2D;
import org.mkui.graphics.IGraphics;
import org.mkui.graphics.IHeadless;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\t\b'\u0018\u0000 ;*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00020\u0003:\u0001;B)\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ&\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J&\u0010!\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000eH\u0002J\b\u0010\"\u001a\u0004\u0018\u00010\u0018J\u0006\u0010#\u001a\u00020\u000bJ\u001e\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J(\u0010*\u001a\u00020+2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\b\u0010-\u001a\u0004\u0018\u00010.J\u0006\u0010/\u001a\u00020+J\u001a\u00100\u001a\u00020+2\u0010\u00101\u001a\f\u0012\u0006\u0012\u0004\u0018\u000103\u0018\u000102H&J\u000e\u00104\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u00104\u001a\u00020+2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u00105\u001a\u00020\u000e2\u0006\u00106\u001a\u00020\u000eJ\u0016\u00104\u001a\u00020+2\u0006\u00107\u001a\u00020\u001a2\u0006\u00108\u001a\u00020\u001aJ \u00109\u001a\u00020\u001a2\u0006\u0010:\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)H$R\u001e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0012\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006<"}, d2={"Lcom/macrofocus/plot/guide/ValueAxis;", "Color", "Font", "Lcom/macrofocus/plot/guide/AbstractAxis;", "fontFactory", "Lorg/mkui/font/CPFontFactory;", "headless", "Lorg/mkui/graphics/IHeadless;", "label", "", "standardTickUnits", "Lcom/macrofocus/plot/guide/TickUnitSource;", "(Lorg/mkui/font/CPFontFactory;Lorg/mkui/graphics/IHeadless;Ljava/lang/String;Lcom/macrofocus/plot/guide/TickUnitSource;)V", "<set-?>", "", "isAutoTickUnitSelection", "()Z", "isInverted", "isVerticalTickLabels", "minorTickCount", "", "getMinorTickCount", "()I", "range", "Lcom/macrofocus/plot/guide/Range;", "findMaximumTickLabelHeight", "", "ticks", "", "Lcom/macrofocus/plot/guide/Tick;", "g2", "Lorg/mkui/graphics/IGraphics;", "vertical", "findMaximumTickLabelWidth", "getRange", "getStandardTickUnits", "lengthToJava2D", "length", "area", "Lorg/mkui/geom/Rectangle2D;", "edge", "Lcom/macrofocus/plot/guide/RectangleEdge;", "reserveSpace", "", "plotArea", "space", "Lcom/macrofocus/plot/guide/AxisSpace;", "setAutoTickUnitSelection", "setFormatOverride", "format", "Lcom/macrofocus/common/format/CPFormat;", "", "setRange", "turnOffAutoRange", "notify", "lower", "upper", "valueToJava2D", "value", "Companion", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public abstract class ValueAxis<Color, Font>
extends AbstractAxis<Color, Font> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean isInverted;
    @NotNull
    private final TickUnitSource standardTickUnits;
    private final int minorTickCount;
    private final boolean isVerticalTickLabels;
    @Nullable
    private Range range;
    private boolean isAutoTickUnitSelection;
    public static final int $stable = 8;
    public static final int MAXIMUM_TICK_COUNT = 500;
    @NotNull
    private static final Range DEFAULT_RANGE = new Range(0.0, 1.0);
    private static final boolean DEFAULT_INVERTED = false;
    private static final boolean DEFAULT_AUTO_TICK_UNIT_SELECTION = true;

    protected ValueAxis(@NotNull CPFontFactory fontFactory, @NotNull IHeadless headless, @Nullable String label, @NotNull TickUnitSource standardTickUnits) {
        Intrinsics.checkNotNullParameter((Object)fontFactory, (String)"fontFactory");
        Intrinsics.checkNotNullParameter((Object)headless, (String)"headless");
        Intrinsics.checkNotNullParameter((Object)standardTickUnits, (String)"standardTickUnits");
        super(fontFactory, headless, label);
        this.range = DEFAULT_RANGE;
        this.isInverted = false;
        this.isAutoTickUnitSelection = true;
        this.standardTickUnits = standardTickUnits;
        Polygon p1 = new Polygon();
        p1.addPoint(0, 0);
        p1.addPoint(-2, 2);
        p1.addPoint(2, 2);
        Polygon p2 = new Polygon();
        p2.addPoint(0, 0);
        p2.addPoint(-2, -2);
        p2.addPoint(2, -2);
        Polygon p3 = new Polygon();
        p3.addPoint(0, 0);
        p3.addPoint(-2, -2);
        p3.addPoint(-2, 2);
        Polygon p4 = new Polygon();
        p4.addPoint(0, 0);
        p4.addPoint(2, -2);
        p4.addPoint(2, 2);
        this.isVerticalTickLabels = false;
        this.minorTickCount = 0;
    }

    public final boolean isInverted() {
        return this.isInverted;
    }

    public final int getMinorTickCount() {
        return this.minorTickCount;
    }

    public final boolean isVerticalTickLabels() {
        return this.isVerticalTickLabels;
    }

    public final boolean isAutoTickUnitSelection() {
        return this.isAutoTickUnitSelection;
    }

    public final void reserveSpace(@NotNull IGraphics g2, @NotNull Rectangle2D plotArea, @NotNull RectangleEdge edge, @Nullable AxisSpace space) {
        Intrinsics.checkNotNullParameter((Object)g2, (String)"g2");
        Intrinsics.checkNotNullParameter((Object)plotArea, (String)"plotArea");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        AxisSpace space2 = space;
        if (space2 == null) {
            space2 = new AxisSpace();
        }
        if (!this.isVisible()) {
            return;
        }
        double tickLabelHeight = 0.0;
        double tickLabelWidth = 0.0;
        if (this.isTickLabelsVisible()) {
            List<ValueTick> ticks = this.refreshTicks(g2, plotArea, edge);
            if (RectangleEdge.Companion.isTopOrBottom(edge)) {
                tickLabelHeight = this.findMaximumTickLabelHeight((Iterable<Tick>)ticks, g2, this.isVerticalTickLabels);
            } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
                tickLabelWidth = this.findMaximumTickLabelWidth((Iterable<Tick>)ticks, g2, this.isVerticalTickLabels);
            }
        }
        Rectangle2D labelEnclosure = this.getLabelEnclosure(g2, edge);
        if (RectangleEdge.Companion.isTopOrBottom(edge)) {
            double labelHeight = labelEnclosure.getHeight();
            space2.add(labelHeight + tickLabelHeight, edge);
        } else if (RectangleEdge.Companion.isLeftOrRight(edge)) {
            double labelWidth = labelEnclosure.getWidth();
            space2.add(labelWidth + tickLabelWidth, edge);
        }
    }

    private final double findMaximumTickLabelHeight(Iterable<? extends Tick> ticks, IGraphics g2, boolean vertical) {
        RectangleInsets insets = this.getTickLabelInsets();
        double maxHeight = 0.0;
        if (vertical) {
            for (Tick tick : ticks) {
                float labelWidth = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), tick.getText());
                if (!((double)labelWidth + insets.getTop() + insets.getBottom() > maxHeight)) continue;
                maxHeight = (double)labelWidth + insets.getTop() + insets.getBottom();
            }
        } else {
            maxHeight = (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "ABCxyz") + insets.getTop() + insets.getBottom();
        }
        return maxHeight;
    }

    private final double findMaximumTickLabelWidth(Iterable<? extends Tick> ticks, IGraphics g2, boolean vertical) {
        RectangleInsets insets = this.getTickLabelInsets();
        double maxWidth = 0.0;
        if (vertical) {
            maxWidth = (double)this.getHeadless().getStringHeight(g2, this.getTickLabelFont(), "ABCxyz") + insets.getTop() + insets.getBottom();
        } else {
            for (Tick tick : ticks) {
                float labelWidth = this.getHeadless().getStringWidth(g2, this.getTickLabelFont(), tick.getText());
                if (!((double)labelWidth + insets.getLeft() + insets.getRight() > maxWidth)) continue;
                maxWidth = (double)labelWidth + insets.getLeft() + insets.getRight();
            }
        }
        return maxWidth;
    }

    @Nullable
    public final Range getRange() {
        return this.range;
    }

    public final void setRange(@NotNull Range range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.setRange(range, true, true);
    }

    public final void setRange(@NotNull Range range, boolean turnOffAutoRange, boolean notify) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
    }

    public final void setRange(double lower, double upper) {
        this.setRange(new Range(lower, upper));
    }

    public final void setAutoTickUnitSelection() {
        if (this.isAutoTickUnitSelection) {
            this.isAutoTickUnitSelection = false;
        }
    }

    @NotNull
    public final TickUnitSource getStandardTickUnits() {
        return this.standardTickUnits;
    }

    public final double lengthToJava2D(double length, @NotNull Rectangle2D area, @NotNull RectangleEdge edge) {
        Intrinsics.checkNotNullParameter((Object)area, (String)"area");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        double zero = this.valueToJava2D(0.0, area, edge);
        double l = this.valueToJava2D(length, area, edge);
        return Math.abs(l - zero);
    }

    protected abstract double valueToJava2D(double var1, @NotNull Rectangle2D var3, @NotNull RectangleEdge var4);

    public abstract void setFormatOverride(@Nullable CPFormat<Object> var1);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/macrofocus/plot/guide/ValueAxis$Companion;", "", "()V", "DEFAULT_AUTO_TICK_UNIT_SELECTION", "", "DEFAULT_INVERTED", "DEFAULT_RANGE", "Lcom/macrofocus/plot/guide/Range;", "MAXIMUM_TICK_COUNT", "", "macrofocus-slider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

