/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.slider;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.math.Histogram;
import com.macrofocus.slider.AbstractRangeSliderModel;
import com.macrofocus.slider.RangeSliderEvent;
import com.macrofocus.slider.RangeSliderListener;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\bJ\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020*H\u0016J\u0010\u00102\u001a\u0002002\u0006\u00103\u001a\u000204H\u0002J\u0010\u00105\u001a\u0002002\u0006\u00103\u001a\u000204H\u0002J\u0010\u00106\u001a\u0002002\u0006\u00101\u001a\u00020*H\u0016J\u0010\u00107\u001a\u0002002\u0006\u00108\u001a\u000209H\u0016J \u0010:\u001a\u0002002\u0006\u00108\u001a\u0002092\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H\u0016J \u0010;\u001a\u0002002\u0006\u00108\u001a\u0002092\u0006\u0010<\u001a\u00020\u00032\u0006\u0010=\u001a\u00020\u0003H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u001e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001e\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u001e\u0010\u000f\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\fR\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\fR\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u0014\u0010\u001c\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\fR\u0014\u0010\u001e\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\fR\u001e\u0010 \u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\fR\u001e\u0010\"\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\fR\u001e\u0010$\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\fR\u001e\u0010&\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003@RX\u0096\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\fR\u0014\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010+\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010\fR\u0014\u0010-\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010\f\u00a8\u0006@"}, d2={"Lcom/macrofocus/slider/SimpleRangeSliderModel;", "Lcom/macrofocus/slider/AbstractRangeSliderModel;", "min", "", "max", "(DD)V", "minExtent", "maxExtent", "(DDDD)V", "<set-?>", "currentExtent", "getCurrentExtent", "()D", "currentMaximum", "getCurrentMaximum", "currentMinimum", "getCurrentMinimum", "extent", "getExtent", "histogram", "Lcom/macrofocus/common/math/Histogram;", "getHistogram", "()Lcom/macrofocus/common/math/Histogram;", "setHistogram", "(Lcom/macrofocus/common/math/Histogram;)V", "isInvertedScale", "", "()Z", "lowerMaximumValue", "getLowerMaximumValue", "lowerMinimumValue", "getLowerMinimumValue", "maximum", "getMaximum", "maximumExtent", "getMaximumExtent", "minimum", "getMinimum", "minimumExtent", "getMinimumExtent", "sliderListeners", "", "Lcom/macrofocus/slider/RangeSliderListener;", "upperMaximumValue", "getUpperMaximumValue", "upperMinimumValue", "getUpperMinimumValue", "addSliderListener", "", "rangeSliderListener", "notifySliderChanged", "eventRange", "Lcom/macrofocus/slider/RangeSliderEvent;", "notifySliderScaleChanged", "removeSliderListener", "reset", "source", "", "setMinMax", "setValues", "rangeMin", "rangeMax", "toString", "", "macrofocus-slider"})
@StabilityInferred(parameters=0)
public final class SimpleRangeSliderModel
extends AbstractRangeSliderModel {
    private double currentMinimum;
    private double currentMaximum;
    private double currentExtent;
    private double minimum;
    private double maximum;
    private double minimumExtent;
    private double maximumExtent;
    @NotNull
    private List<RangeSliderListener> sliderListeners;
    @Nullable
    private Histogram histogram;
    public static final int $stable = 8;

    @Override
    public double getCurrentMinimum() {
        return this.currentMinimum;
    }

    @Override
    public double getCurrentMaximum() {
        return this.currentMaximum;
    }

    @Override
    public double getCurrentExtent() {
        return this.currentExtent;
    }

    @Override
    public double getMinimum() {
        return this.minimum;
    }

    @Override
    public double getMaximum() {
        return this.maximum;
    }

    @Override
    public double getMinimumExtent() {
        return this.minimumExtent;
    }

    @Override
    public double getMaximumExtent() {
        return this.maximumExtent;
    }

    @Override
    @Nullable
    public Histogram getHistogram() {
        return this.histogram;
    }

    public void setHistogram(@Nullable Histogram histogram) {
        this.histogram = histogram;
    }

    public SimpleRangeSliderModel(double min, double max) {
        this.minimum = min;
        this.maximum = max;
        this.currentMinimum = min;
        this.currentMaximum = max;
        this.currentExtent = Math.max(this.getCurrentMinimum(), this.getCurrentMaximum()) - Math.min(this.getCurrentMinimum(), this.getCurrentMaximum());
        this.minimumExtent = 0.0;
        this.maximumExtent = Math.max(min, max) - Math.min(min, max);
        this.sliderListeners = new ArrayList();
    }

    public SimpleRangeSliderModel(double min, double max, double minExtent, double maxExtent) {
        this.minimum = min;
        this.maximum = max;
        this.currentMinimum = min;
        this.currentMaximum = max;
        this.currentExtent = Math.max(this.getCurrentMinimum(), this.getCurrentMaximum()) - Math.min(this.getCurrentMinimum(), this.getCurrentMaximum());
        this.minimumExtent = minExtent;
        this.maximumExtent = maxExtent;
        this.sliderListeners = new ArrayList();
    }

    @Override
    public void setValues(@NotNull Object source, double rangeMin, double rangeMax) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(this.getCurrentMinimum() == rangeMin) || !(this.getCurrentMaximum() == rangeMax)) {
            double previousRangeMin = this.getCurrentMinimum();
            double previousRangeMax = this.getCurrentMaximum();
            this.currentMinimum = rangeMin;
            this.currentMaximum = rangeMax;
            this.currentExtent = Math.max(rangeMin, rangeMax) - Math.min(rangeMin, rangeMax);
            RangeSliderEvent eventRange = new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), previousRangeMin, previousRangeMax);
            this.notifySliderChanged(eventRange);
        }
    }

    @Override
    public void setMinMax(@NotNull Object source, double min, double max) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(this.getMinimum() == min) || !(this.getMaximum() == max)) {
            this.minimum = min;
            this.maximum = max;
            RangeSliderEvent eventRange = new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), this.getCurrentMinimum(), this.getCurrentMaximum());
            this.notifySliderScaleChanged(eventRange);
        }
    }

    @Override
    public double getExtent() {
        return Math.max(this.getMinimum(), this.getMaximum()) - Math.min(this.getMinimum(), this.getMaximum());
    }

    @Override
    public double getUpperMinimumValue() {
        return this.getMinimum();
    }

    @Override
    public double getUpperMaximumValue() {
        return this.getMaximum();
    }

    @Override
    public double getLowerMinimumValue() {
        return this.getMinimum();
    }

    @Override
    public double getLowerMaximumValue() {
        return this.getMaximum();
    }

    @Override
    public void reset(@NotNull Object source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        double previousRangeMin = this.getCurrentMinimum();
        double previousRangeMax = this.getCurrentMaximum();
        if (!this.isInvertedScale()) {
            double tmpRangeMin;
            double tmpRangeMax = this.getMaximum();
            if (tmpRangeMax - (tmpRangeMin = this.getMinimum()) > this.getMaximumExtent()) {
                tmpRangeMax = this.getCurrentMinimum() + this.getMaximumExtent();
                tmpRangeMin = this.getCurrentMinimum();
                if (tmpRangeMax > this.getMaximum()) {
                    tmpRangeMin -= tmpRangeMax - this.getMaximum();
                    tmpRangeMax = this.getMaximum();
                }
            }
            this.currentMaximum = tmpRangeMax;
            this.currentMinimum = tmpRangeMin;
            if (!(this.getCurrentMinimum() == previousRangeMin) || !(this.getCurrentMaximum() == previousRangeMax)) {
                this.notifySliderChanged(new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), previousRangeMin, previousRangeMax));
            }
        } else {
            double tmpRangeMax = this.getMaximum();
            double tmpRangeMin = this.getMinimum();
            if (tmpRangeMin - tmpRangeMax > this.getMaximumExtent()) {
                tmpRangeMax = this.getCurrentMinimum();
                tmpRangeMin = this.getCurrentMinimum() + this.getMaximumExtent();
                if (tmpRangeMin > this.getMinimum()) {
                    tmpRangeMax -= tmpRangeMin - this.getMinimum();
                    tmpRangeMin = this.getMinimum();
                }
            }
            this.currentMaximum = tmpRangeMax;
            this.currentMinimum = tmpRangeMin;
            if (!(this.getCurrentMinimum() == previousRangeMin) || !(this.getCurrentMaximum() == previousRangeMax)) {
                this.notifySliderChanged(new RangeSliderEvent(this, source, this.getCurrentMinimum(), this.getCurrentMaximum(), previousRangeMin, previousRangeMax));
            }
        }
    }

    @Override
    public void addSliderListener(@NotNull RangeSliderListener rangeSliderListener) {
        Intrinsics.checkNotNullParameter((Object)rangeSliderListener, (String)"rangeSliderListener");
        this.sliderListeners.add(rangeSliderListener);
    }

    @Override
    public void removeSliderListener(@NotNull RangeSliderListener rangeSliderListener) {
        Intrinsics.checkNotNullParameter((Object)rangeSliderListener, (String)"rangeSliderListener");
        this.sliderListeners.remove(rangeSliderListener);
    }

    private final void notifySliderChanged(RangeSliderEvent eventRange) {
        for (RangeSliderListener listener2 : this.sliderListeners) {
            listener2.sliderChanged(eventRange);
        }
    }

    private final void notifySliderScaleChanged(RangeSliderEvent eventRange) {
        for (RangeSliderListener listener2 : this.sliderListeners) {
            listener2.sliderScaleChanged(eventRange);
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "[rangeMin=" + this.getCurrentMinimum() + ",rangeMax=" + this.getCurrentMaximum() + ",amount=" + this.getCurrentExtent() + ",min=" + this.getMinimum() + ",max=" + this.getMaximum() + "]";
    }

    @Override
    public boolean isInvertedScale() {
        return this.getMinimum() > this.getMaximum();
    }
}

