package com.macrofocus.plot.guide
/**
 * A collection of useful static utility methods for handling classes and object
 * instantiation.
 */
internal object ObjectUtilities {
    /**
     * Returns `true` if the two objects are equal OR both
     * `null`.
     *
     * @param o1 object 1 (`null` permitted).
     * @param o2 object 2 (`null` permitted).
     *
     * @return `true` or `false`.
     */
    fun equal(o1: Any?, o2: Any?): Boolean {
        return if (o1 === o2) {
            true
        } else o1 != null && o1 == o2
    }
}