/*
 * Copyright (c) 2013 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.plot.guide

import com.macrofocus.common.transform.OneDScreenTransform
import org.mkui.component.CPComponent
import org.mkui.component.SwingComponentWrapper

class SwingXNumberOneDScreenTransformAxisGuide @JvmOverloads constructor(type: Guide.Type = Guide.Type.Bottom) : AbstractSwingAxisGuide(type) {
    constructor(type: Guide.Type, coordinateAxis: OneDScreenTransform) : this(type) {
        setCoordinateAxis(coordinateAxis)
    }

    constructor(coordinateAxis: OneDScreenTransform) : this(Guide.Type.Bottom) {
        setCoordinateAxis(coordinateAxis)
    }

    override val component: CPComponent
        get() = SwingComponentWrapper(nativeComponent)
}