package com.macrofocus.slider

import java.awt.Rectangle
import java.awt.event.MouseAdapter
import java.awt.event.MouseEvent
import java.awt.event.MouseMotionAdapter

class SimpleRangeSliderController @JvmOverloads constructor(sliderView: SliderView, accelerationFactor: Double = 1.0, symetric: Boolean = false) :
    SliderController {
    private var savedX = 0
    private var savedY = 0
    private var selectedRectangle: Rectangle? = null

    constructor(sliderView: SliderView, symetric: Boolean) : this(sliderView, 1.0, symetric) {}

    private fun setValues(model: RangeSliderModel?, translatedMin: Double, translatedMax: Double): Boolean {
        return if (model!!.currentMinimum != translatedMin || model.currentMaximum != translatedMax) {
//            if(translatedMax - translatedMin >= model.getMinimumExtent()) {
            model.setValues(this, translatedMin, translatedMax)
            true
            //            } else {
//                return true;
//            }
        } else {
            false
        }
    }

    init {
        sliderView.addMouseListener(object : MouseAdapter() {
            override fun mouseClicked(e: MouseEvent) {
                if (sliderView.isEnabled()) {
                    if (e.clickCount > 1) {
                        sliderView.rangeSliderModel!!.reset(this)
                    }
                }
            }

            override fun mousePressed(e: MouseEvent) {
                if (sliderView.isEnabled()) {
                    sliderView.component?.requestFocus()
                    savedX = e.x
                    savedY = e.y
                    val x = e.x
                    val y = e.y
                    if (sliderView.minBounds.contains(x, y)) {
                        selectedRectangle = sliderView.minBounds
                        e.consume()
                    } else if (sliderView.maxBounds.contains(x, y)) {
                        selectedRectangle = sliderView.maxBounds
                        e.consume()
                    } else if (sliderView.thumbBounds.contains(x, y)) {
                        selectedRectangle = sliderView.thumbBounds
                        val model = sliderView.rangeSliderModel
                        if (!model!!.isFullRange) {
                            e.consume()
                        }
                    } else {
                        val model = sliderView.rangeSliderModel
                        if (sliderView.orientation == SliderView.VERTICAL) {
                            if (!model!!.isInvertedScale) {
                                if (y > sliderView.minBounds.y) {
                                    var translatedMin = model.currentMinimum - model.currentExtent
                                    var translatedMax = model.currentMaximum - model.currentExtent
                                    if (translatedMin < model.minimum) {
                                        translatedMin = model.minimum
                                        translatedMax = model.minimum + model.currentExtent
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                } else {
                                    var translatedMin = model.currentMinimum + model.currentExtent
                                    var translatedMax = model.currentMaximum + model.currentExtent
                                    if (translatedMax > model.maximum) {
                                        translatedMin = model.maximum - model.currentExtent
                                        translatedMax = model.maximum
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                }
                            } else {
                                if (y > sliderView.minBounds.y) {
                                    var translatedMin = model.currentMinimum + model.currentExtent
                                    var translatedMax = model.currentMaximum + model.currentExtent
                                    if (translatedMin > model.minimum) {
                                        translatedMin = model.minimum
                                        translatedMax = model.minimum - model.currentExtent
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                } else {
                                    var translatedMin = model.currentMinimum - model.currentExtent
                                    var translatedMax = model.currentMaximum - model.currentExtent
                                    if (translatedMax < model.maximum) {
                                        translatedMin = model.maximum + model.currentExtent
                                        translatedMax = model.maximum
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                }
                            }
                        } else {
                            if (!model!!.isInvertedScale) {
                                if (x < sliderView.minBounds.x) {
                                    var translatedMin = model.currentMinimum - model.currentExtent
                                    var translatedMax = model.currentMaximum - model.currentExtent
                                    if (translatedMin < model.minimum) {
                                        translatedMin = model.minimum
                                        translatedMax = model.minimum + model.currentExtent
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                } else {
                                    var translatedMin = model.currentMinimum + model.currentExtent
                                    var translatedMax = model.currentMaximum + model.currentExtent
                                    if (translatedMax > model.maximum) {
                                        translatedMin = model.maximum - model.currentExtent
                                        translatedMax = model.maximum
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                }
                            } else {
                                if (x < sliderView.minBounds.x) {
                                    var translatedMin = model.currentMinimum + model.currentExtent
                                    var translatedMax = model.currentMaximum + model.currentExtent
                                    if (translatedMin > model.minimum) {
                                        translatedMin = model.minimum
                                        translatedMax = model.minimum - model.currentExtent
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                } else {
                                    var translatedMin = model.currentMinimum - model.currentExtent
                                    var translatedMax = model.currentMaximum - model.currentExtent
                                    if (translatedMax < model.maximum) {
                                        translatedMin = model.maximum + model.currentExtent
                                        translatedMax = model.maximum
                                    }
                                    setValues(model, translatedMin, translatedMax)
                                }
                            }
                        }
                    }
                }
            }

            override fun mouseReleased(e: MouseEvent) {
                selectedRectangle = null
            }
        })
        sliderView.addMouseMotionListener(object : MouseMotionAdapter() {
            override fun mouseDragged(e: MouseEvent) {
                if (sliderView.isEnabled()) {
                    if (selectedRectangle != null) {
                        var changed = false
                        var deltaMouse: Int
                        val ratio: Double
                        deltaMouse = if (sliderView.orientation == SliderView.VERTICAL) {
                            savedY - e.y
                        } else {
                            e.x - savedX
                        }
                        val sliderModel = sliderView.rangeSliderModel
                        if (sliderModel!!.isInvertedScale) {
                            deltaMouse = -deltaMouse
                        }
                        ratio = if (sliderView.screenRange > 0) {
                            deltaMouse.toDouble() / sliderView.screenRange.toDouble() * accelerationFactor
                        } else {
                            0.0
                        }
                        val delta = sliderModel.extent * ratio
                        if (selectedRectangle == sliderView.thumbBounds) {
                            var translatedMin = sliderModel.currentMinimum + delta
                            var translatedMax = sliderModel.currentMaximum + delta
                            if (sliderModel.currentMinimum != sliderModel.minimum || sliderModel.currentMaximum != sliderModel.maximum) {
                                if (!sliderModel.isInvertedScale) {
                                    if (translatedMin < sliderModel.minimum) {
                                        translatedMin = sliderModel.minimum
                                        translatedMax = sliderModel.minimum + sliderModel.currentExtent
                                    }
                                    if (translatedMax > sliderModel.maximum) {
                                        translatedMin = sliderModel.maximum - sliderModel.currentExtent
                                        translatedMax = sliderModel.maximum
                                    }
                                    if (translatedMin < sliderModel.lowerMinimumValue) {
                                        translatedMin = sliderModel.lowerMinimumValue
                                        translatedMax = sliderModel.lowerMinimumValue + sliderModel.currentExtent
                                    }
                                    if (translatedMin > sliderModel.lowerMaximumValue) {
                                        translatedMin = sliderModel.lowerMaximumValue
                                        translatedMax = sliderModel.lowerMaximumValue + sliderModel.currentExtent
                                    }
                                    if (translatedMax < sliderModel.upperMinimumValue) {
                                        translatedMin = sliderModel.upperMinimumValue - sliderModel.currentExtent
                                        translatedMax = sliderModel.upperMinimumValue
                                    }
                                    if (translatedMax > sliderModel.upperMaximumValue) {
                                        translatedMin = sliderModel.upperMaximumValue - sliderModel.currentExtent
                                        translatedMax = sliderModel.upperMaximumValue
                                    }
                                } else {
                                    if (translatedMin > sliderModel.minimum) {
                                        translatedMin = sliderModel.minimum
                                        translatedMax = sliderModel.minimum + sliderModel.currentExtent
                                    }
                                    if (translatedMax < sliderModel.maximum) {
                                        translatedMin = sliderModel.maximum - sliderModel.currentExtent
                                        translatedMax = sliderModel.maximum
                                    }
                                    if (translatedMin > sliderModel.lowerMinimumValue) {
                                        translatedMin = sliderModel.lowerMinimumValue
                                        translatedMax = sliderModel.lowerMinimumValue + sliderModel.currentExtent
                                    }
                                    if (translatedMin < sliderModel.lowerMaximumValue) {
                                        translatedMin = sliderModel.lowerMaximumValue
                                        translatedMax = sliderModel.lowerMaximumValue + sliderModel.currentExtent
                                    }
                                    if (translatedMax > sliderModel.upperMinimumValue) {
                                        translatedMin = sliderModel.upperMinimumValue - sliderModel.currentExtent
                                        translatedMax = sliderModel.upperMinimumValue
                                    }
                                    if (translatedMax < sliderModel.upperMaximumValue) {
                                        translatedMin = sliderModel.upperMaximumValue - sliderModel.currentExtent
                                        translatedMax = sliderModel.upperMaximumValue
                                    }
                                }
                                changed = setValues(sliderModel, translatedMin, translatedMax)
                            }
                        } else if (selectedRectangle == sliderView.minBounds) {
                            var translatedMin = sliderModel.currentMinimum + delta
                            var translatedMax = sliderModel.currentMaximum - delta
                            if (!sliderModel.isInvertedScale) {
                                if (translatedMin < sliderModel.minimum) {
                                    translatedMin = sliderModel.minimum
                                }
                                if (translatedMax > sliderModel.maximum) {
                                    translatedMax = sliderModel.maximum
                                }
                                if (translatedMin < sliderModel.lowerMinimumValue) {
                                    translatedMin = sliderModel.lowerMinimumValue
                                }
                                if (translatedMin > sliderModel.lowerMaximumValue) {
                                    translatedMin = sliderModel.lowerMaximumValue
                                }
                                if (translatedMax < sliderModel.upperMinimumValue) {
                                    translatedMax = sliderModel.upperMinimumValue
                                }
                                if (translatedMax > sliderModel.upperMaximumValue) {
                                    translatedMax = sliderModel.upperMaximumValue
                                }
                                if (sliderModel.currentMaximum - translatedMin > sliderModel.maximumExtent) {
                                    translatedMin = sliderModel.currentMaximum - sliderModel.maximumExtent
                                }
                                if (sliderModel.currentMaximum - translatedMin < sliderModel.minimumExtent) {
                                    translatedMin = sliderModel.currentMaximum - sliderModel.minimumExtent
                                }
                            } else {
                                if (translatedMin > sliderModel.minimum) {
                                    translatedMin = sliderModel.minimum
                                }
                                if (translatedMax < sliderModel.maximum) {
                                    translatedMax = sliderModel.maximum
                                }
                                if (translatedMin > sliderModel.lowerMinimumValue) {
                                    translatedMin = sliderModel.lowerMinimumValue
                                }
                                if (translatedMin < sliderModel.lowerMaximumValue) {
                                    translatedMin = sliderModel.lowerMaximumValue
                                }
                                if (translatedMax > sliderModel.upperMinimumValue) {
                                    translatedMax = sliderModel.upperMinimumValue
                                }
                                if (translatedMax < sliderModel.upperMaximumValue) {
                                    translatedMax = sliderModel.upperMaximumValue
                                }
                                if (translatedMax - sliderModel.currentMinimum > sliderModel.maximumExtent) {
                                    translatedMax = sliderModel.currentMinimum + sliderModel.maximumExtent
                                }
                                if (translatedMax - sliderModel.currentMinimum < sliderModel.minimumExtent) {
                                    translatedMax = sliderModel.currentMinimum + sliderModel.minimumExtent
                                }
                            }
                            changed = if (!symetric) {
                                setValues(sliderModel, translatedMin, sliderModel.currentMaximum)
                            } else {
                                setValues(sliderModel, translatedMin, translatedMax)
                            }
                        } else if (selectedRectangle == sliderView.maxBounds) {
                            var translatedMin = sliderModel.currentMinimum - delta
                            var translatedMax = sliderModel.currentMaximum + delta
                            if (!sliderModel.isInvertedScale) {
                                if (translatedMin < sliderModel.minimum) {
                                    translatedMin = sliderModel.minimum
                                }
                                if (translatedMax > sliderModel.maximum) {
                                    translatedMax = sliderModel.maximum
                                }
                                if (translatedMax < sliderModel.upperMinimumValue) {
                                    translatedMax = sliderModel.upperMinimumValue
                                }
                                if (translatedMax > sliderModel.upperMaximumValue) {
                                    translatedMax = sliderModel.upperMaximumValue
                                }
                                if (translatedMin < sliderModel.lowerMinimumValue) {
                                    translatedMin = sliderModel.lowerMinimumValue
                                }
                                if (translatedMin > sliderModel.lowerMaximumValue) {
                                    translatedMin = sliderModel.lowerMaximumValue
                                }
                                if (translatedMax - sliderModel.currentMinimum > sliderModel.maximumExtent) {
                                    translatedMax = sliderModel.currentMinimum + sliderModel.maximumExtent
                                }
                                if (translatedMax - sliderModel.currentMinimum < sliderModel.minimumExtent) {
                                    translatedMax = sliderModel.currentMinimum + sliderModel.minimumExtent
                                }
                            } else {
                                if (translatedMin > sliderModel.minimum) {
                                    translatedMin = sliderModel.minimum
                                }
                                if (translatedMax < sliderModel.maximum) {
                                    translatedMax = sliderModel.maximum
                                }
                                if (translatedMax > sliderModel.upperMinimumValue) {
                                    translatedMax = sliderModel.upperMinimumValue
                                }
                                if (translatedMax < sliderModel.upperMaximumValue) {
                                    translatedMax = sliderModel.upperMaximumValue
                                }
                                if (translatedMin > sliderModel.lowerMinimumValue) {
                                    translatedMin = sliderModel.lowerMinimumValue
                                }
                                if (translatedMin < sliderModel.lowerMaximumValue) {
                                    translatedMin = sliderModel.lowerMaximumValue
                                }
                                if (sliderModel.currentMaximum - translatedMin > sliderModel.maximumExtent) {
                                    translatedMin = sliderModel.currentMaximum - sliderModel.maximumExtent
                                }
                                if (sliderModel.currentMaximum - translatedMin < sliderModel.minimumExtent) {
                                    translatedMin = sliderModel.currentMaximum - sliderModel.minimumExtent
                                }
                            }
                            changed = if (!symetric) {
                                setValues(sliderModel, sliderModel.currentMinimum, translatedMax)
                            } else {
                                setValues(sliderModel, translatedMin, translatedMax)
                            }
                        }
                        if (changed) {
                            savedX = e.x
                            savedY = e.y
                        }
                    }
                }
            }
        })
    }
}