package com.macrofocus.slider

import java.awt.Rectangle
import javax.swing.SwingConstants

interface SliderView {
    val rangeSliderModel: RangeSliderModel?
    val minBounds: Rectangle
    val maxBounds: Rectangle
    val thumbBounds: Rectangle
    val trackBounds: Rectangle?
    val orientation: Int
    fun toWorld(value: Int): Double
    fun toScreen(value: Double): Int
    val screenRange: Int
    val component: java.awt.Component?
    fun addMouseListener(listener: java.awt.event.MouseListener?)
    fun addMouseMotionListener(listener: java.awt.event.MouseMotionListener?)
    fun setVisible(visible: Boolean)
    fun isEnabled(): Boolean

    companion object {
        val HORIZONTAL: Int = SwingConstants.HORIZONTAL
        val VERTICAL: Int = SwingConstants.VERTICAL
    }
}