/*
 * Copyright (c) 2007, Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.slider.plaf

import com.macrofocus.slider.JRangeSlider
import com.macrofocus.slider.RangeSliderModel
import java.awt.Graphics
import java.awt.Rectangle
import javax.swing.JComponent
import javax.swing.SwingConstants
import javax.swing.plaf.ComponentUI

abstract class RangeSliderUI : ComponentUI() {
    abstract fun paintRange(
        rangeSliderModel: RangeSliderModel?,
        sliderView: JRangeSlider,
        g: Graphics,
        orientation: Int,
        trackBounds: Rectangle?,
        thumbBounds: Rectangle?
    )

    abstract fun paintThumb(sliderView: JRangeSlider, g: Graphics, orientation: Int, thumbBounds: Rectangle?)
    abstract fun paintArrowButton(sliderView: JComponent, g: Graphics, direction: Int, bounds: Rectangle)

    companion object {
        const val HORIZONTAL = SwingConstants.HORIZONTAL
        const val VERTICAL = SwingConstants.VERTICAL
        const val NORTH = SwingConstants.NORTH
        const val SOUTH = SwingConstants.SOUTH
        const val EAST = SwingConstants.EAST
        const val WEST = SwingConstants.WEST
    }
}