/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.slider.plaf.synth

/*
import com.macrofocus.slider.JRangeSlider
import com.macrofocus.slider.RangeSliderModel
import com.macrofocus.slider.plaf.basic.BasicRangeSliderUI
import java.awt.*
import java.awt.image.RasterFormatException
import javax.swing.JButton
import javax.swing.JComponent
import javax.swing.JScrollBar
import javax.swing.UIManager
import javax.swing.plaf.ComponentUI
import javax.swing.plaf.synth.Region
import javax.swing.plaf.synth.SynthConstants
import javax.swing.plaf.synth.SynthContext

class SynthRangeSliderUI : BasicRangeSliderUI() {
    private val scrollBar: JScrollBar = JScrollBar()
    private val button: JButton = JButton()
    override fun paint(g: Graphics, c: JComponent) {
        scrollBar.setOrientation(if ((c as JRangeSlider).orientation == JRangeSlider.Companion.HORIZONTAL) JScrollBar.HORIZONTAL else JScrollBar.VERTICAL)
        scrollBar.setSize(c.getSize())
        MJComponent.configureRenderingHints(g)
        super.paint(g, c)
    }

    override fun paintRange(
        rangeSliderModel: RangeSliderModel?,
        view: JRangeSlider,
        g: Graphics,
        orientation: Int,
        trackBounds: Rectangle?,
        thumbBounds: Rectangle?
    ) {
        if (view.isPaintTrack) {
            if (view.histogramRenderer != null) {
                val c: Component = view.histogramRenderer.getRangeSliderHistogramRendererComponent(view, rangeSliderModel.histogram)
                if (c != null) {
                    c.setSize(trackBounds!!.width, trackBounds.height)
                    val g2 = g.create(trackBounds.x, trackBounds.y, trackBounds.width, trackBounds.height)
                    c.paint(g2)
                    g2.dispose()
                }
            } else {
//                if (view.isOpaque()) {
                val x = thumbBounds!!.x
                val y = thumbBounds.y
                val w = thumbBounds.width
                val h = thumbBounds.height
                val context: SynthContext = SyntheticaLookAndFeel.createContext(scrollBar, Region.SCROLL_BAR, SynthConstants.DEFAULT)
                ScrollBarPainter.getInstance().paintScrollBarTrackBackground(context, g, x, y, w, h)
                ScrollBarPainter.getInstance().paintScrollBarTrackBorder(
                    context, g, trackBounds!!.x,
                    trackBounds.y, trackBounds.width, trackBounds.height
                )
                //                }
            }

            //        if (trackHighlight == DECREASE_HIGHLIGHT) {
            //            paintDecreaseHighlight(g);
            //        } else if (trackHighlight == INCREASE_HIGHLIGHT) {
            //            paintIncreaseHighlight(g);
            //        }
        }
    }

    override fun paintThumb(view: JRangeSlider, g: Graphics, orientation: Int, thumbBounds: Rectangle?) {
        if (view.isPaintThumb && view.histogramRenderer == null) {
            if (thumbBounds!!.isEmpty || !view.isEnabled()) {
                return
            }
            val x = thumbBounds.x
            val y = thumbBounds.y
            val w = thumbBounds.width
            val h = thumbBounds.height
            val context: SynthContext = SyntheticaLookAndFeel.createContext(scrollBar, Region.SCROLL_BAR, SynthConstants.DEFAULT)
            ScrollBarPainter.getInstance().paintScrollBarThumbBackground(
                context,
                g,
                x,
                y,
                w,
                h,
                if (view.orientation == JRangeSlider.Companion.HORIZONTAL) JScrollBar.HORIZONTAL else JScrollBar.VERTICAL
            )
            ScrollBarPainter.getInstance()
                .paintScrollBarThumbBorder(context, g, thumbBounds.x, thumbBounds.y, thumbBounds.width, thumbBounds.height, scrollBar.getOrientation())
        }
    }

    override fun paintArrowButton(sliderView: JComponent, g: Graphics, direction: Int, bounds: Rectangle) {
        val x = bounds.x
        val y = bounds.y
        val w = bounds.width
        val h = bounds.height
        button.putClientProperty("__arrow_direction__", Integer.valueOf(direction))
        button.setSize(w, h)
        button.validate()
        val context: SynthContext = SyntheticaLookAndFeel.createContext(button, Region.ARROW_BUTTON, SynthConstants.ENABLED)

        // Avoid java.awt.image.RasterFormatException: negative or zero width caused by
        // org.apache.batik.ext.awt.g2d.AbstractGraphics2D.drawImage(AbstractGraphics2D.java:774)
        // de.javasoft.plaf.synthetica.painter.ImagePainter.drawImage(ImagePainter.java:762)
        // de.javasoft.plaf.synthetica.painter.ArrowButtonPainter.paintArrowButtonBackground(ArrowButtonPainter.java:173)
        // and
        // java.lang.IllegalArgumentException: Width (0) and height (0) cannot be <= 0
        // at org.freehep.graphicsio.AbstractVectorGraphicsIO.drawImage(AbstractVectorGraphicsIO.java:504)
        try {
            ArrowButtonPainter.getInstance().paintArrowButtonBackground(context, g, x, y, w, h)
            ArrowButtonPainter.getInstance().paintArrowButtonBorder(context, g, x, y, w, h)
            ArrowButtonPainter.getInstance().paintArrowButtonForeground(context, g, x, y, w, h, direction)
        } catch (e: IllegalArgumentException) {
            e.printStackTrace()
        } catch (e: RasterFormatException) {
            e.printStackTrace()
        }
    }

    companion object {
        private val rangeSliderUI = SynthRangeSliderUI()
        fun createUI(c: JComponent?): ComponentUI {
            return rangeSliderUI
        }

        fun getString(key: String, c: Component): String {
            return Companion[key, c] as String
        }

        fun getInsets(key: String, c: Component): Insets {
            val insets = Companion[key, c] as Insets
            return insets ?: Insets(0, 0, 0, 0)
        }

        operator fun get(key: String, c: Component): Any {
            val name = c.name ?: return UIManager.get(key)
            val o: Any = UIManager.get(StringBuilder(key).append(".").append(name).toString())
            return o ?: UIManager.get(key)
        }
    }

    init {
        button.setEnabled(true)
        button.setFocusable(false)
        button.setName("ScrollBar.button")
        button.setDefaultCapable(false)
        scrollBar.add(button)
        backgroundControlColor = Color(189, 218, 240)
        thumbColor = Color(189, 218, 240)
        backgroundColor = Color(220, 235, 246)
    }
}*/
