@file:OptIn(ExperimentalTime::class)

package com.macrofocus.plot.guide

import kotlin.time.ExperimentalTime
import kotlin.time.Instant

/** A tick used by the [DateAxis] class.  */
class DateTick(
    tickType: TickType, date: Instant?, label: String,
    textAnchor: TextAnchor?, rotationAnchor: TextAnchor?,
    angle: Double
) : ValueTick(
    tickType, date!!.toEpochMilliseconds().toDouble(), label, textAnchor, rotationAnchor,
    angle
) {
    /** The date.  */
    private val date: Instant?

    /**
     * Creates a new date tick.
     *
     * @param date           the date.
     * @param label          the label.
     * @param textAnchor     the part of the label that is aligned to the anchor
     * point.
     * @param rotationAnchor defines the rotation point relative to the text.
     * @param angle          the rotation angle (in radians).
     */
    constructor(
        date: Instant?, label: String,
        textAnchor: TextAnchor?, rotationAnchor: TextAnchor?,
        angle: Double
    ) : this(TickType.Major, date, label, textAnchor, rotationAnchor, angle) {
    }

    /**
     * Tests this tick for equality with an arbitrary object.
     *
     * @param obj the object to test (`null` permitted).
     *
     * @return A boolean.
     */
    override fun equals(obj: Any?): Boolean {
        if (obj === this) {
            return true
        }
        if (obj !is DateTick) {
            return false
        }
        return if (!com.macrofocus.plot.guide.ObjectUtilities.equal(date, obj.date)) {
            false
        } else super.equals(obj)
    }

    /**
     * Returns a hash code for this object.
     *
     * @return A hash code.
     */
    override fun hashCode(): Int {
        return date.hashCode()
    }

    /**
     * Creates a new date tick.
     *
     * @param tickType       the tick type.
     * @param date           the date.
     * @param label          the label.
     * @param textAnchor     the part of the label that is aligned to the anchor
     * point.
     * @param rotationAnchor defines the rotation point relative to the text.
     * @param angle          the rotation angle (in radians).
     */
    init {
        this.date = date
    }
}