package com.macrofocus.plot.guide

/** A value tick.  */
abstract class ValueTick
/**
 * Creates a new value tick.
 *
 * @param tickType       the tick type (major or minor).
 * @param value          the value.
 * @param label          the label.
 * @param textAnchor     the part of the label that is aligned to the anchor
 * point.
 * @param rotationAnchor defines the rotation point relative to the label.
 * @param angle          the rotation angle (in radians).
 */(
    /** The tick type (major or minor).  */
    private val tickType: TickType,
    /** The value.  */
    var value: Double, label: String,
    textAnchor: TextAnchor?, rotationAnchor: TextAnchor?,
    angle: Double
) : Tick(label, textAnchor, rotationAnchor, angle) {
    /**
     * Returns the value.
     *
     * @return The value.
     */
    /**
     * Creates a new value tick.
     *
     * @param value          the value.
     * @param label          the label.
     * @param textAnchor     the part of the label that is aligned to the anchor
     * point.
     * @param rotationAnchor defines the rotation point relative to the label.
     * @param angle          the rotation angle (in radians).
     */
    constructor(
        value: Double, label: String,
        textAnchor: TextAnchor?, rotationAnchor: TextAnchor?,
        angle: Double
    ) : this(TickType.Major, value, label, textAnchor, rotationAnchor, angle) {
        this.value = value
    }

    /**
     * Tests this tick for equality with an arbitrary object.
     *
     * @param obj the object to test (`null` permitted).
     *
     * @return A boolean.
     */
    override fun equals(obj: Any?): Boolean {
        if (obj === this) {
            return true
        }
        if (obj !is ValueTick) {
            return false
        }
        val that = obj
        if (value != that.value) {
            return false
        }
        return if (tickType != that.tickType) {
            false
        } else super.equals(obj)
    }

    /** Used to indicate the tick type (MAJOR or MINOR).  */
    enum class TickType {
        /** Major tick.  */
        Major,

        /** Minor tick.  */
        Minor
    }
}