package org.mkui.canvas

interface MouseListener {
    /**
     * Invoked when the mouse button has been clicked (pressed
     * and released) on a component.
     */
    fun mouseClicked(event: org.mkui.canvas.MouseEvent)

    /**
     * Invoked when a mouse button has been pressed on a component.
     */
    fun mousePressed(event: org.mkui.canvas.MouseEvent)

    /**
     * Invoked when a mouse button has been released on a component.
     */
    fun mouseReleased(event: org.mkui.canvas.MouseEvent)

    /**
     * Invoked when the mouse enters a component.
     */
    fun mouseEntered(event: org.mkui.canvas.MouseEvent)

    /**
     * Invoked when the mouse exits a component.
     */
    fun mouseExited(event: org.mkui.canvas.MouseEvent)
}