/*
 * Copyright (c) 2010 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.colormap

import com.macrofocus.common.interval.MutableInterval
import com.macrofocus.common.properties.MutableProperty
import org.mkui.color.CPColor
import org.mkui.palette.MutablePalette
import kotlin.js.JsExport
import kotlin.js.JsName

/**
 * Defines the requirements for a colormap that can change.
 */
@JsExport
interface MutableColorMap : ColorMap {
    override var interval: MutableInterval?
    override var palette: MutablePalette?

    override var brightness: Int
    override var saturation: Int
    override var alpha: Float
    override var nullColor: CPColor?

    fun setMatching(matching: ColorMap.Matching?)
    fun setAssignments(assignments: ColorMap.Assignments?)
    fun setUnderColor(underColor: CPColor?)
    fun setOverColor(overColor: CPColor?)

    val paletteProperty: MutableProperty<MutablePalette?>
    val nullColorProperty: MutableProperty<CPColor?>
    val underColorSetProperty: MutableProperty<Boolean>
    val underColorStoreProperty: MutableProperty<CPColor?>
    val underColorProperty: MutableProperty<CPColor?>
    val overColorSetProperty: MutableProperty<Boolean>
    val overColorStoreProperty: MutableProperty<CPColor?>
    val overColorProperty: MutableProperty<CPColor?>
    val isInvertedProperty: MutableProperty<Boolean>
    val colorCountSetProperty: MutableProperty<Boolean>
    val colorCountProperty: MutableProperty<Int>
    val brightnessProperty: MutableProperty<Int>
    val saturationProperty: MutableProperty<Int>

    @JsName("assignColorsSet")
    fun assignColors(values: Set<*>, normalized: Boolean)
    fun assignColors(vararg values: Any?)

    @JsName("assignColorsIterable")
    fun assignColors(values: Iterable<Any?>)
    fun setColor(value: Any?, color: CPColor?)
    fun clearAssignedColor()
    fun setProperty(property: String?, value: Any?)
    fun resetAssignedValues()
}