/*
 * Copyright (c) 2017 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.colormap.editor

import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.selection.SingleSelection
import org.mkui.colormap.MutableColorMap
import kotlin.reflect.KClass

interface ColorMapPanelModel<C> {
    val colorSelection: SingleSelection<C?>
    fun getCategoricalColorMap(column: C): MutableColorMap
    fun getCustomColorMap(column: C): MutableColorMap
    fun getPredefinedColorMap(column: C): MutableColorMap
    fun getFormat(column: C): CPFormat<Any?>?
    fun getNumericMin(column: C): Number?
    fun getNumericMax(column: C): Number?
    fun getCurrentColorMap(column: C): MutableColorMap?
    fun setCurrentColorMap(column: C, colorMap: MutableColorMap?)
    fun getType(column: C): KClass<*>
}