/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.component.menu

import com.macrofocus.common.command.ToggleUICommand
import com.macrofocus.common.properties.PropertyEvent
import com.macrofocus.common.properties.PropertyListener


class ToggleGroup {
    private val commands: MutableList<ToggleUICommand?> = ArrayList<ToggleUICommand?>()
    fun add(command: ToggleUICommand?) {
        commands.add(command)
        command!!.toggleProperty().addPropertyListener(object : PropertyListener<Boolean> {
            override fun propertyChanged(event: PropertyEvent<Boolean>) {
                if (event.newValue) {
                    for (toggleUICommand in commands) {
                        if (toggleUICommand !== command) {
                            toggleUICommand!!.toggleProperty().value = false
                        }
                    }
                }
            }
        })
    }
}