/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.geom

import kotlin.math.floor
import kotlin.math.sqrt

class Point(var ix: Int, var iy: Int) : Point2D {
    override fun toString(): String {
        return "Point.Integer{" +
                "x=" + x +
                ", y=" + y +
                '}'
    }

    override val x: Double
        get() = ix.toDouble()

    override val y: Double
        get() = iy.toDouble()

    override fun setLocation(x: Double, y: Double) {
        this.ix = floor(x + 0.5).toInt()
        this.iy = floor(y + 0.5).toInt()
    }

    /**
     * Returns the distance from this `Point2D` to a
     * specified `Point2D`.
     *
     * @param pt the specified point to be measured
     * against this `Point2D`
     *
     * @return the distance between this `Point2D` and
     * the specified `Point2D`.
     */
    override fun distance(pt: Point2D): Double {
        val px: Double = pt.x - x
        val py: Double = pt.y - y
        return sqrt(px * px + py * py)
    }

    override fun distanceSq(e: Point2D): Double {
        val px: Double = e.x - x
        val py: Double = e.y - y
        return px * px + py * py
    }
}