/*
 * Copyright (c) 2020 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.geom

import com.macrofocus.common.transform.OneDScreenTransform

/**
 * Helper class for dealing with screen transforms.
 */
object ScreenTransformHelper {
    fun worldToScreen(xModel: OneDScreenTransform, yModel: OneDScreenTransform): AffineTransform {
        return if (yModel.isWorldCoordinatesInverted) {
            val xs: Double = xModel.screenSize / xModel.worldRange
            val ys: Double = yModel.screenSize / yModel.worldRange
            val at = AffineTransform()
            at.setToScale(xs, ys)
            at.translate(-xModel.worldMin, -yModel.worldMin)
            at
        } else {
            val xs: Double = xModel.screenSize / xModel.worldRange
            val ys: Double = yModel.screenSize / yModel.worldRange
            val tx: Double = -xModel.worldMin * xs
            val ty: Double = yModel.worldMin * ys + yModel.screenSize
            AffineTransform(xs, 0.0, 0.0, -ys, tx, ty)
        }
    }
}