package org.mkui.geom.curve

import com.macrofocus.common.collection.arraycopy

internal class Bag {
    private var data: Array<Any?>
    private var size = 0
    fun add(o: Any?) {
        insert(o, size)
    }

    fun insert(o: Any?, index: Int) {
        ensureCapacity(size + 1)
        arraycopy(data, index, data, index + 1, size - index)
        data[index] = o
        size++
    }

    fun ensureCapacity(capacity: Int) {
        if (capacity > data.size) {
            var x = 2 * data.size
            if (x < capacity) x = capacity
            val arr = arrayOfNulls<Any>(x)
            arraycopy(data, 0, arr, 0, size)
            data = arr
        }
    }

    fun size(): Int {
        return size
    }

    operator fun get(index: Int): Any? {
        return data[index]
    }

    init {
        data = arrayOfNulls(2)
    }
}