package org.mkui.geom.curve

/**
 * Curves that extend the ParametricCurve class are continuous and can use the
 * BinaryCurveApproximationAlgorithm class to generate a sequence of points that
 * approximate the curve.  Note: Approximate means a finite set of points that
 * are *on* the curve, <u>not</u> close to the curve.
 *
 * @see BinaryCurveApproximationAlgorithm
 *
 * @see org.mkui.geom.curve.Curve
 */
abstract class ParametricCurve(cp: ControlPath?, gp: GroupIterator?) : Curve(cp, gp) {
    /**
     * The eval method evaluates a point on a curve given a parametric value "t".  The parametric
     * value "t" is stored in the last index location of the specified double array.  *This value
     * should not be changed*.  The dimension of the point to evaluate is p.length - 1.  The result
     * of the evaluation is placed in index locations 0 .. p.length - 2 (inclusive).
     *
     *
     * The eval method should remain protected except for those curves that do no need any
     * preparation to be done in the appendTo method.
     */
    abstract fun eval(p: DoubleArray)

    /**
     * The sample limit specifies how many additional subdivisions are done to ensure that there
     * are no missed pieces of the curve.  The sample limit must be &gt;= 0.
     */
    abstract val sampleLimit: Int
}