package org.mkui.geom.curve

/**
 * A representation of an n-dimensional point.  The dimension of the point is the length of the
 * array returned by the location method.
 *
 * @see org.mkui.geom.curve.ControlPath
 *
 * @see org.mkui.geom.curve.Curve
 */
interface Point {
    /**
     * Returns either a new array with a copy of the data or a direct reference to the array.
     * In the case where a copy is returned and later modified, the setLocation must be called
     * to apply the data.
     */
    val location: DoubleArray
}