package org.mkui.geom.curve

/**
 * A value-vector is a sequence of values that some curves use to define themselves,
 * sometimes called a knot-vector or a weight-vector.  The values are stored using an
 * array.
 */
class ValueVector(value: DoubleArray?, size: Int) {
    private val size: Int
    private val value: DoubleArray?

    /**
     * Returns the number of values in the value array.
     */
    fun size(): Int {
        return size
    }

    /**
     * Returns the value at the specified index.
     */
    operator fun get(index: Int): Double {
        return value!![index]
    }

    /**
     * Creates a ValueVector using the specified array and initial size.
     */
    init {
        this.value = value
        this.size = size
    }
}