/*
 * Copyright (c) 2011 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.palette

import kotlin.math.max
import kotlin.math.min
import kotlin.math.round

/**
 * This class provides a skeletal implementation of the Palette interface to minimize the effort required to implement this interface.
 */
abstract class AbstractPalette : Palette {
    override var colorCount = 0
    override val cycle: Palette.Cycle? = Palette.Cycle.NONE
    protected fun getEntry(fraction: Double, colorCount: Int, paletteSize: Int): Int {
        val entry: Double = round(fraction * (colorCount - 1))
        val f = entry / (colorCount - 1)
        return min(
            colorCount - 1,
            max(0, round(f * (paletteSize - 1)).toInt())
        )
    }

    open val isInverted: Boolean
        get() = false
 }