package org.mkui.transform

import com.macrofocus.common.interval.Interval
import com.macrofocus.common.transform.OneDScreenTransform
import com.macrofocus.common.transform.ScreenTransformListener
import org.mkui.geom.Point
import org.mkui.geom.Point2D
import org.mkui.geom.Rectangle
import org.mkui.geom.Rectangle2D

/**
 * Screen transformation for X and Y coordinates.
 */
interface TwoDScreenTransform {
    fun screenToWorld(screen: Point): Point2D
    fun screenToWorld(screen: Rectangle): Rectangle2D
    fun worldToScreen(world: Point2D): Point
    fun worldToScreen(world: Rectangle2D): Rectangle
    val xWorldInterval: Interval
    val yWorldInterval: Interval
    val isAffine: Boolean

    fun addScreenTransformListener(listener: ScreenTransformListener)
    fun addWeakScreenTransformListener(listener: ScreenTransformListener)
    fun removeScreenTransformListener(listener: ScreenTransformListener)
    fun removeScreenTransformListeners()
    val x: OneDScreenTransform
    val y: OneDScreenTransform

    fun setMaintainAspectRatio(maintainAspectRatio: Boolean)
    fun xWorldToScreen(x: Double): Int
    fun yWorldToScreen(y: Double): Int
    val screenWidth: Int
    val screenHeight: Int

    fun xScreenToWorld(x: Int): Double
    fun yScreenToWorld(y: Int): Double
}
