package org.mkui.canvas

import com.macrofocus.common.collection.CollectionFactory
import org.mkui.component.CPComponent
import org.mkui.graphics.CPGraphicsContext2D
import org.w3c.dom.CanvasRenderingContext2D
import react.FunctionalComponent

actual open class CPCanvas : CPComponent {
    val layers = CollectionFactory.copyOnWriteArrayList<org.mkui.canvas.CanvasRenderingContext2DLayer>()
    private val listeners: MutableList<CanvasListener> = ArrayList()
    val nativeComponent = org.mkui.canvas.FunctionalCPCanvas(layers, listeners)
//    val nativeComponent = ReactCanvas(graphicsContextDrawings)


    fun addNativeLayer(d: org.mkui.canvas.CanvasRenderingContext2DLayer) {
        layers.add(d)
    }

    actual fun addLayer(d: GraphicsContextDrawing) {
        layers.add(object : org.mkui.canvas.CanvasRenderingContext2DLayer {
            override fun prepare(width: Int, height: Int) {

            }

            override fun render(g: CanvasRenderingContext2D?) {
                d.draw(CPGraphicsContext2D(g!!), getWidth(), getHeight())
            }
        })
    }

    override fun getNativeComponent(): FunctionalComponent<*> {
        return nativeComponent.getNativeComponent()
    }

    actual open fun getWidth(): Double {
        return nativeComponent.width.toDouble()
    }

    actual open fun getHeight(): Double {
        return nativeComponent.height.toDouble()
    }

    actual open fun addCanvasListener(l: CanvasListener) {
        listeners.add(l)
    }

    protected open fun notifySizeChanged(width: Int, height: Int) {
        for (listener in listeners) {
            listener.sizeChange(width, height)
        }
    }

    actual fun redraw() {
        nativeComponent.redraw()
    }

    actual fun addMouseListener(l: MouseListener) {
        nativeComponent.addMouseListener(l)
    }

    actual open fun addMouseMotionListener(l: MouseMotionListener) {
        nativeComponent.addMouseMotionListener(l)
    }

    actual fun addMouseWheelListener(l: MouseWheelListener) {
        nativeComponent.addMouseWheelListener(l)
    }

    actual fun addKeyListener(l: KeyListener) {
        nativeComponent.addKeyListener(l)
    }

    actual fun addContextMenuListener(l: ContextMenuListener) {
        nativeComponent.addContextMenuListener(l)
    }
}