package org.mkui.graphics

import org.mkui.color.CPColor
import org.mkui.font.CPFont
import org.mkui.text.CPTextMetrics
import org.w3c.dom.CanvasGradient
import org.w3c.dom.CanvasRenderingContext2D
import kotlin.math.PI

actual class CPGraphicsContext2D(val gc: CanvasRenderingContext2D) : GraphicsContext2D {
    override fun getTextMetrics(text: String): CPTextMetrics {
        return CanvasRenderingContext2DTextMetrics(gc, text)
    }

    override fun drawGradient(
        color1: CPColor,
        color2: CPColor,
        x: Double,
        y: Double,
        w: Double,
        h: Double,
        isVertical: Boolean
    ) {
        val gradient: CanvasGradient
        gradient = if (isVertical) {
            gc.createLinearGradient(0.0, y, 0.0, y + h)
        } else {
            gc.createLinearGradient(x, 0.0, x + w, 0.0)
        }
        gradient.addColorStop(0.0, color1.toJavaScriptColor())
        gradient.addColorStop(1.0, color2.toJavaScriptColor())
        gc.fillStyle = gradient
        gc.fillRect(x, y, w, h)
    }

    override fun save() {
        gc.save()
    }

    override fun restore() {
        gc.restore()
    }

    override fun translate(x: Double, y: Double) {
        gc.translate(x, y)
    }

    override fun scale(x: Double, y: Double) {
        gc.scale(x, y)
    }

    override fun rotate(degrees: Double) {
        gc.rotate(degrees * PI / 180)
    }

    override fun transform(
        mxx: Double,
        myx: Double,
        mxy: Double,
        myy: Double,
        mxt: Double,
        myt: Double
    ) {
        gc.transform(mxx, myx, mxy, myy, mxt, myt)
    }

    override fun setTransform(
        mxx: Double,
        myx: Double,
        mxy: Double,
        myy: Double,
        mxt: Double,
        myt: Double
    ) {
        gc.setTransform(mxx, myx, mxy, myy, mxt, myt)
    }

    //    @Override
    fun getGlobalAlpha(): Double {
        return gc.globalAlpha
    }

    override fun setGlobalAlpha(alpha: Double) {
        gc.globalAlpha = alpha
    }

    override fun setFill(p: CPColor) {
        gc.fillStyle = p.toJavaScriptColor()
    }

//    @Override
//    public CssColor getFill() {
//        return gc.fillStyle;
//    }

    //    @Override
    //    public CssColor getFill() {
    //        return gc.fillStyle;
    //    }
    override fun setStroke(p: CPColor) {
        gc.strokeStyle = p.toJavaScriptColor()
    }

//    @Override
//    public Color getStroke() {
//        return (Color)gc.getStroke();
//    }

    //    @Override
    //    public Color getStroke() {
    //        return (Color)gc.getStroke();
    //    }
    override fun setLineWidth(lw: Double) {
        gc.lineWidth = lw
    }

//    @Override
//    public double getLineWidth() {
//        return gc.getLineWidth();
//    }

    //    @Override
    //    public double getLineWidth() {
    //        return gc.getLineWidth();
    //    }
    override fun setFont(f: CPFont) {
        gc.font = f.toString()
    }

    override fun fillText(text: String, x: Double, y: Double) {
        gc.fillText(text, x, y)
    }

    override fun beginPath() {
        gc.beginPath()
    }

    override fun moveTo(x0: Double, y0: Double) {
        gc.moveTo(x0, y0)
    }

//    @Override
//    public void setLineDashOffset(double dashOffset) {
//        gc.setLineDashOffset(dashOffset);
//    }

//    @Override
//    public double getLineDashOffset() {
//        return gc.getLineDashOffset();
//    }

    //    @Override
    //    public void setLineDashOffset(double dashOffset) {
    //        gc.setLineDashOffset(dashOffset);
    //    }
    //    @Override
    //    public double getLineDashOffset() {
    //        return gc.getLineDashOffset();
    //    }
    override fun lineTo(x1: Double, y1: Double) {
        gc.lineTo(x1, y1)
    }

//    @Override
//    public GWTFont getFont() {
//        return gc.getFont();
//    }

    //    @Override
    //    public GWTFont getFont() {
    //        return gc.getFont();
    //    }
    override fun quadraticCurveTo(xc: Double, yc: Double, x1: Double, y1: Double) {
        gc.quadraticCurveTo(xc, yc, x1, y1)
    }

    override fun bezierCurveTo(
        xc1: Double,
        yc1: Double,
        xc2: Double,
        yc2: Double,
        x1: Double,
        y1: Double
    ) {
        gc.bezierCurveTo(xc1, yc1, xc2, yc2, x1, y1)
    }

    override fun rect(x: Double, y: Double, w: Double, h: Double) {
        gc.rect(x, y, w, h)
    }

    override fun closePath() {
        gc.closePath()
    }

    override fun fill() {
        gc.fill()
    }

    override fun stroke() {
        gc.stroke()
    }

    override fun clip() {
        gc.clip()
    }

    override fun fillRect(x: Double, y: Double, w: Double, h: Double) {
        gc.fillRect(x, y, w, h)
    }

    override fun strokeRect(x: Double, y: Double, w: Double, h: Double) {
        gc.strokeRect(x, y, w, h)
    }

    override fun strokeLine(x1: Double, y1: Double, x2: Double, y2: Double) {
        gc.beginPath()
        gc.moveTo(x1, y1)
        gc.lineTo(x2, y2)
        gc.stroke()
    }

//    @Override
//    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
//        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
//    }

    //    @Override
    //    public void arc(double centerX, double centerY, double radiusX, double radiusY, double startAngle, double length) {
    //        gc.arc(centerX, centerY, radiusX, radiusY, startAngle, length);
    //    }
    //    @Override
    fun getMiterLimit(): Double {
        return gc.miterLimit
    }

//    @Override
//    public void appendSVGPath(String svgpath) {
//        gc.appendSVGPath(svgpath);
//    }

    //    @Override
    //    public void appendSVGPath(String svgpath) {
    //        gc.appendSVGPath(svgpath);
    //    }
    //    @Override
    fun setMiterLimit(ml: Double) {
        gc.miterLimit = ml
    }

    //    @Override
    fun getLineDashes(): Array<Double> {
        return gc.getLineDash()
    }

    //    @Override
    fun setLineDashes(dashes: Array<Double>) {
        gc.setLineDash(dashes)
    }

    //    @Override
    fun strokeText(text: String, x: Double, y: Double) {
        gc.strokeText(text, x, y)
    }

    //    @Override
    fun fillText(text: String, x: Double, y: Double, maxWidth: Double) {
        gc.fillText(text, x, y, maxWidth)
    }

    //    @Override
    fun strokeText(
        text: String,
        x: Double,
        y: Double,
        maxWidth: Double
    ) {
        gc.strokeText(text, x, y, maxWidth)
    }

    //    @Override
    fun arcTo(
        x1: Double,
        y1: Double,
        x2: Double,
        y2: Double,
        radius: Double
    ) {
        gc.arcTo(x1, y1, x2, y2, radius)
    }

    //    @Override
    fun isPointInPath(x: Double, y: Double): Boolean {
        return gc.isPointInPath(x, y)
    }

//    @Override
//    public void fillOval(double x, double y, double w, double h) {
//        gc.fillOval(x, y, w, h);
//    }

//    @Override
//    public void strokeOval(double x, double y, double w, double h) {
//        gc.strokeOval(x, y, w, h);
//    }

//    @Override
//    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
//        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
//    }

//    @Override
//    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
//        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
//    }

//    @Override
//    public void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
//        gc.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
//    }

//    @Override
//    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
//        gc.strokeRoundRect(x, y,, w, h, arcWidth, arcHeight);
//    }

    //    @Override
    //    public void fillOval(double x, double y, double w, double h) {
    //        gc.fillOval(x, y, w, h);
    //    }
    //    @Override
    //    public void strokeOval(double x, double y, double w, double h) {
    //        gc.strokeOval(x, y, w, h);
    //    }
    //    @Override
    //    public void fillArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
    //        gc.fillArc(x, y, w, h, startAngle, arcExtent, closure);
    //    }
    //    @Override
    //    public void strokeArc(double x, double y, double w, double h, double startAngle, double arcExtent, ArcType closure) {
    //        gc.strokeArc(x, y, w, h, startAngle, arcExtent, closure);
    //    }
    //    @Override
    //    public void fillRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
    //        gc.fillRoundRect(x, y, w, h, arcWidth, arcHeight);
    //    }
    //    @Override
    //    public void strokeRoundRect(double x, double y, double w, double h, double arcWidth, double arcHeight) {
    //        gc.strokeRoundRect(x, y,, w, h, arcWidth, arcHeight);
    //    }
    //    @Override
    fun clearRect(x: Double, y: Double, w: Double, h: Double) {
        gc.clearRect(x, y, w, h)
    }

//    @Override
//    public void fillPolygon(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.fillPolygon(xPoints, yPoints, nPoints);
//    }

//    @Override
//    public void strokePolygon(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.strokePolygon(xPoints, yPoints, nPoints);
//    }

//    @Override
//    public void strokePolyline(double[] xPoints, double[] yPoints, int nPoints) {
//        gc.strokePolyline(xPoints, yPoints, nPoints);
//    }
}