package org.mkui.graphics

import org.khronos.webgl.Uint8ClampedArray
import org.w3c.dom.CanvasRenderingContext2D
import org.w3c.dom.HTMLCanvasElement
import org.w3c.dom.ImageData

actual class CPImage actual constructor(override val width: Int, override val height: Int) : Image {
    override val nativeImage: org.w3c.dom.Image
        get() {return storedImage!!}

    private var storedImage: org.w3c.dom.Image? = org.w3c.dom.Image(width, height)

    private var canvas: HTMLCanvasElement? = CPImageFactory.canvas
    private var context2d: CanvasRenderingContext2D? = CPImageFactory.context2D

    private var imageData: ImageData? = context2d!!.createImageData(width.toDouble(), height.toDouble())

    override fun setPixels(x: Int, y: Int, w: Int, h: Int, iArray: IntArray?) {
        val data: Uint8ClampedArray = imageData!!.data
        //        int[] dst = Int8Array.ConstructorLengthUnionType.of(data).asIntArray();
        for (i in iArray!!.indices) {
//            dst[i] = iArray[i];
            data.asDynamic()[i] = iArray[i]
//            data.set(i, iArray[i])
        }

        canvas!!.width = nativeImage.width
        canvas!!.height = nativeImage.height

        context2d!!.putImageData(imageData!!, 0.0, 0.0)

        nativeImage.src = canvas!!.toDataURL("image/png")
    }

    override val isOneSamplePerArrayElement: Boolean
        get() = true
    override val isLoaded: Boolean
        get() = nativeImage.complete

    override fun flush() {
        canvas = null
        context2d = null

        storedImage = null
        imageData = null
    }
}