package org.mkui.graphics

import org.mkui.text.CPTextMetrics
import org.w3c.dom.CanvasRenderingContext2D

class CanvasRenderingContext2DTextMetrics(val context: CanvasRenderingContext2D, text: String) : CPTextMetrics {
    private val width = computeWidth(text)
    private val ascent = computeAscent()

    override fun getWidth(): Double {
        return width
    }

    override fun getAscent(): Double {
        return ascent
    }

    private fun computeWidth(text: String): Double {
        return context.measureText(text).width
    }

    private fun computeAscent() : Double {
        return context.measureText("M").width
    }
}