package org.mkui.window

import org.mkui.component.CPComponent
import react.*
import react.dom.*

external interface ReactWindowProps: RProps {
}

external interface ReactWindowState: RState {
    var content: CPComponent?
}

class ReactWindow : RComponent<ReactWindowProps, ReactWindowState>() {
    override fun RBuilder.render() {
        if(state.content != null) {
            val nativeComponent = state.content!!.getNativeComponent()
            child(nativeComponent) {
            }
        }
    }
}