/*
 * Copyright (c) 2016 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.component.menu

import com.macrofocus.common.command.Command
import com.macrofocus.common.command.ToggleUICommand
import com.macrofocus.common.command.UICommand
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property
import org.kamaeleo.component.CPComponent

expect class CPMenu : CPComponent {
    constructor(title: String)
    constructor(title: Property<String?>)
    fun addMenu(title: String): CPMenu
    fun addMenu(title: Property<String?>): CPMenu
    fun addAction(title: String?, keystroke: String?, command: Command?)
    fun addAction(command: UICommand?)
    fun addEllipsisAction(title: String, keystroke: String?, command: Command?)
    fun addEllipsisAction(command: UICommand?)
    fun addCheckBox(title: String, keystroke: String?, property: MutableProperty<Boolean?>?)

    fun addCheckBox(command: ToggleUICommand?)
    fun <T> addRadio(title: String, property: MutableProperty<T?>?, vararg values: T?)
    fun addRadio(command: ToggleUICommand?, group: ToggleGroup)
    fun addLink(property: Property<String?>, url: String?)
    fun addSeparator()
    interface ViewCommand<V> : Command {
        fun setup(view: V?)
    }
}