/*
 * Copyright (c) 2019 Macrofocus GmbH. All Rights Reserved.
 */
package org.mkui.component.menu

import com.macrofocus.common.command.Command
import com.macrofocus.common.command.ToggleUICommand
import com.macrofocus.common.command.UICommand
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.Property


interface CPMenuBuilder {
    fun build(): CPMenu?
    fun addMenu(menu: CPMenu?): CPMenuBuilder?
    fun addAction(
        title: String?,
        keystroke: String?,
        command: Command?
    ): CPMenuBuilder?

    fun addAction(command: UICommand?): CPMenuBuilder?
    fun addEllipsisAction(
        title: String?,
        keystroke: String?,
        command: Command?
    ): CPMenuBuilder?

    fun addEllipsisAction(command: UICommand?): CPMenuBuilder?
    fun addCheckBox(
        title: String?,
        keystroke: String?,
        property: MutableProperty<Boolean?>?
    ): CPMenuBuilder?

    fun addCheckBox(command: ToggleUICommand?): CPMenuBuilder?
    fun <T> addRadio(
        title: String?,
        property: MutableProperty<T?>?,
        vararg values: T?
    ): CPMenuBuilder?

    fun addRadio(
        command: ToggleUICommand?,
        group: ToggleGroup?
    ): CPMenuBuilder?

    fun addLink(
        property: Property<String?>?,
        url: String?
    ): CPMenuBuilder?

    fun addSeparator(): CPMenuBuilder?
}