package org.mkui.component.menu;

import com.macrofocus.common.command.ToggleUICommand;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.common.properties.PropertyListener;

import javax.swing.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class SwingRadioButtonMenuItem {
    private final JRadioButtonMenuItem menuItem;
    private final ToggleUICommand command;

    private final PropertyListener<String> titleListener = new PropertyListener<String>() {
        @Override
        public void propertyChanged(PropertyEvent<String> event) {
            menuItem.setText(event.getNewValue());
        }
    };

    private final PropertyListener<Boolean> enabledListener = new PropertyListener<Boolean>() {
        @Override
        public void propertyChanged(PropertyEvent<Boolean> event) {
            menuItem.setEnabled(event.getNewValue());
        }
    };

    private final PropertyListener<Boolean> toggleListener = new PropertyListener<Boolean>() {
        @Override
        public void propertyChanged(PropertyEvent<Boolean> event) {
            menuItem.setSelected(event.getNewValue());
        }
    };

    private final ActionListener actionListener = new ActionListener() {
        @Override
        public void actionPerformed(ActionEvent e) {
            command.execute(e.getSource());
            command.toggleProperty().setValue(true);
        }
    };

    public SwingRadioButtonMenuItem(ToggleUICommand command) {
        this.command = command;
        menuItem = new JRadioButtonMenuItem(command.titleProperty().getValue());
        command.titleProperty().addPropertyListener(titleListener);
//        menuItem.setAccelerator(KeyStroke.getKeyStroke(command.keystrokeProperty().getValue()));
//        command.keystrokeProperty().addWeakPropertyListener(new PropertyListener<String>() {
//            @Override
//            public void propertyChanged(PropertyEvent<String> event) {
//                menuItem.setAccelerator(KeyStroke.getKeyStroke(event.getNewValue()));
//            }
//        });
        menuItem.setEnabled(command.enabledProperty().getValue() && command != null);
        command.enabledProperty().addPropertyListener(enabledListener);
        menuItem.addActionListener(actionListener);
        menuItem.setSelected(command.toggleProperty().getValue());
        command.toggleProperty().addPropertyListener(toggleListener);
    }

    public JRadioButtonMenuItem getNativeComponent() {
        return menuItem;
    }
}

