/*
 * Decompiled with CFR 0.152.
 */
package org.mkui.colormap.editor;

import androidx.compose.runtime.Composer;
import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.delegate.Delegate;
import com.macrofocus.common.delegate.MutableLazyKt;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.color.MkColor;
import org.mkui.colormap.ColorMapEvent;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormap.ColorMapListener;
import org.mkui.colormap.MutableColorMap;
import org.mkui.colormap.editor.AbstractCategoricalColorMapEditor;
import org.mkui.colormap.editor.ColorCellRenderer;
import org.mkui.component.CPComponent;
import org.mkui.component.CPComponentProvider;
import org.mkui.component.CPFactory;
import org.mkui.component.button.CPButton;
import org.mkui.component.input.CPColorPicker;
import org.mkui.component.input.CPSlider;
import org.mkui.component.panel.CPFormPanel;
import org.mkui.component.panel.CPVerticalFlowPanel;
import org.mkui.table.Table;
import org.mkui.table.TableFactory;
import org.mkui.visual.Visual;
import org.molap.dataframe.AbstractMutableDataFrame;
import org.molap.dataframe.DataFrame;
import org.molap.dataframe.DataFrameEvent;
import org.molap.dataframe.MutableDataFrame;
import org.molap.index.DefaultUniqueIndex;
import org.molap.index.IntegerRangeUniqueIndex;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001#B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001c\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u0006\u0012\u0002\b\u00030\"H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0018\u001a\u0016\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\u0006\u0012\u0004\u0018\u00010\u001c0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lorg/mkui/colormap/editor/CPCategoricalColorMapEditor;", "Lorg/mkui/colormap/editor/AbstractCategoricalColorMapEditor;", "Lorg/mkui/component/CPComponentProvider;", "factory", "Lorg/mkui/component/CPFactory;", "colorMapFactory", "Lorg/mkui/colormap/ColorMapFactory;", "tableFactory", "Lorg/mkui/table/TableFactory;", "(Lorg/mkui/component/CPFactory;Lorg/mkui/colormap/ColorMapFactory;Lorg/mkui/table/TableFactory;)V", "brightnessSlider", "Lorg/mkui/component/input/CPSlider;", "component", "Lorg/mkui/component/CPComponent;", "getComponent", "()Lorg/mkui/component/CPComponent;", "generateColorsButton", "Lorg/mkui/component/button/CPButton;", "mainPanel", "Lorg/mkui/component/panel/CPVerticalFlowPanel;", "missingValueColor", "Lorg/mkui/component/input/CPColorPicker;", "resetButton", "saturationSlider", "table", "Lorg/mkui/table/Table;", "", "", "", "setColorMap", "", "colorMap", "Lorg/mkui/colormap/MutableColorMap;", "type", "Lkotlin/reflect/KClass;", "ColorsDataFrame", "mkui-molap"})
@StabilityInferred(parameters=0)
public final class CPCategoricalColorMapEditor
extends AbstractCategoricalColorMapEditor
implements CPComponentProvider {
    @NotNull
    private final CPFactory factory;
    @NotNull
    private final ColorMapFactory colorMapFactory;
    @NotNull
    private final CPVerticalFlowPanel mainPanel;
    @NotNull
    private final CPButton generateColorsButton;
    @NotNull
    private final Table<Integer, String, Object> table;
    @NotNull
    private final CPColorPicker missingValueColor;
    @NotNull
    private final CPButton resetButton;
    @NotNull
    private final CPSlider brightnessSlider;
    @NotNull
    private final CPSlider saturationSlider;
    public static final int $stable = 8;

    public CPCategoricalColorMapEditor(@NotNull CPFactory factory, @NotNull ColorMapFactory colorMapFactory, @NotNull TableFactory tableFactory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)colorMapFactory, (String)"colorMapFactory");
        Intrinsics.checkNotNullParameter((Object)tableFactory, (String)"tableFactory");
        this.factory = factory;
        this.colorMapFactory = colorMapFactory;
        this.mainPanel = this.factory.createVerticalFlowPanel(new CPComponent[0]);
        CPFormPanel formPanel = this.factory.createFormPanel();
        this.generateColorsButton = this.factory.createButton("Generate");
        this.table = tableFactory.createTable();
        this.table.setColumnResizePolicy(Table.ColumnResizePolicy.Constrained);
        this.table.setPrefHeight(200.0);
        this.missingValueColor = this.factory.createColorPicker();
        this.resetButton = this.factory.createButton("Reset");
        this.brightnessSlider = this.factory.createSlider();
        this.brightnessSlider.setMinimum(-150.0);
        this.brightnessSlider.setMaximum(150.0);
        this.saturationSlider = this.factory.createSlider();
        this.saturationSlider.setMinimum(-150.0);
        this.saturationSlider.setMaximum(150.0);
        this.mainPanel.add((CPComponent)this.table);
        formPanel.add((CPComponent)this.factory.createLabel("Brightness:"), (CPComponent)this.brightnessSlider);
        formPanel.add((CPComponent)this.factory.createLabel("Saturation:"), (CPComponent)this.saturationSlider);
        formPanel.add((CPComponent)this.factory.createLabel("Missing Values Color:"), (CPComponent)this.missingValueColor);
        this.mainPanel.add((CPComponent)formPanel);
    }

    public void setColorMap(@NotNull MutableColorMap colorMap, @NotNull KClass<?> type) {
        Intrinsics.checkNotNullParameter((Object)colorMap, (String)"colorMap");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        MutableDataFrame dataFrame = (MutableDataFrame)new ColorsDataFrame(colorMap, type);
        SimpleVisualObjects visualObjects = new SimpleVisualObjects((DataFrame)dataFrame);
        SimpleVisual visual = new SimpleVisual(visualObjects, new SimpleColorMapping(this.colorMapFactory, (DataFrame)dataFrame));
        this.table.setModel((DataFrame<Integer, String, Object>)((DataFrame)dataFrame), (Visual<Integer, String>)((Visual)visual));
        this.table.setCellRenderer("Color", new ColorCellRenderer(this.factory, (MutableDataFrame<Integer, String, Object>)dataFrame));
        this.missingValueColor.setProperty(colorMap.getNullColorProperty());
        this.brightnessSlider.setProperty(colorMap.getBrightnessProperty());
        this.saturationSlider.setProperty(colorMap.getSaturationProperty());
    }

    @NotNull
    public CPComponent getComponent() {
        return (CPComponent)this.mainPanel;
    }

    @NotNull
    public Function2<Composer, Integer, Unit> getNativeComponent() {
        return CPComponentProvider.DefaultImpls.getNativeComponent((CPComponentProvider)this);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u0016\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u0003\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u0001B\u0019\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\n\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0018\u0010!\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040\b2\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0016\u0010#\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b2\u0006\u0010$\u001a\u00020\u0002H\u0016J\u001a\u0010%\u001a\u0004\u0018\u00010\u00042\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0003H\u0016J\u0016\u0010&\u001a\u00020'2\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002J\"\u0010(\u001a\u00020)2\u0006\u0010$\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u00032\b\u0010*\u001a\u0004\u0018\u00010\u0004H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\fR\u001b\u0010\u0017\u001a\u00020\u00188VX\u0096\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u001c*\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00180\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0012\u0010\u0007\u001a\u0006\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/mkui/colormap/editor/CPCategoricalColorMapEditor$ColorsDataFrame;", "Lorg/molap/dataframe/AbstractMutableDataFrame;", "", "", "", "colorMap", "Lorg/mkui/colormap/MutableColorMap;", "valueType", "Lkotlin/reflect/KClass;", "(Lorg/mkui/colormap/MutableColorMap;Lkotlin/reflect/KClass;)V", "columnCount", "getColumnCount", "()I", "columnIndex", "Lorg/molap/index/DefaultUniqueIndex;", "getColumnIndex", "()Lorg/molap/index/DefaultUniqueIndex;", "listener", "Lorg/mkui/colormap/ColorMapListener;", "getListener", "()Lorg/mkui/colormap/ColorMapListener;", "rowCount", "getRowCount", "rowIndex", "Lorg/molap/index/IntegerRangeUniqueIndex;", "getRowIndex$delegate", "(Lorg/mkui/colormap/editor/CPCategoricalColorMapEditor$ColorsDataFrame;)Ljava/lang/Object;", "getRowIndex", "()Lorg/molap/index/IntegerRangeUniqueIndex;", "rowIndexDelegate", "Lcom/macrofocus/common/delegate/Delegate;", "getRowIndexDelegate", "()Lcom/macrofocus/common/delegate/Delegate;", "getColumnClass", "column", "getRowClass", "row", "getValueAt", "isCellEditable", "", "setValueAt", "", "value", "mkui-molap"})
    @SourceDebugExtension(value={"SMAP\nCPCategoricalColorMapEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CPCategoricalColorMapEditor.kt\norg/mkui/colormap/editor/CPCategoricalColorMapEditor$ColorsDataFrame\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,147:1\n37#2,2:148\n37#2,2:150\n37#2,2:152\n*S KotlinDebug\n*F\n+ 1 CPCategoricalColorMapEditor.kt\norg/mkui/colormap/editor/CPCategoricalColorMapEditor$ColorsDataFrame\n*L\n109#1:148,2\n130#1:150,2\n131#1:152,2\n*E\n"})
    private static final class ColorsDataFrame
    extends AbstractMutableDataFrame<Integer, String, Object> {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
        @NotNull
        private final MutableColorMap colorMap;
        @NotNull
        private final KClass<?> valueType;
        @NotNull
        private final DefaultUniqueIndex<String> columnIndex;
        @NotNull
        private final Delegate<IntegerRangeUniqueIndex> rowIndexDelegate;
        @NotNull
        private final ColorMapListener listener;

        public ColorsDataFrame(@NotNull MutableColorMap colorMap, @NotNull KClass<?> valueType) {
            Intrinsics.checkNotNullParameter((Object)colorMap, (String)"colorMap");
            Intrinsics.checkNotNullParameter(valueType, (String)"valueType");
            this.colorMap = colorMap;
            this.valueType = valueType;
            Object[] objectArray = new String[]{"Value", "Color"};
            this.columnIndex = new DefaultUniqueIndex(objectArray);
            this.rowIndexDelegate = MutableLazyKt.mutableLazy((Function0)((Function0)new Function0<IntegerRangeUniqueIndex>(this){
                final /* synthetic */ ColorsDataFrame this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                @NotNull
                public final IntegerRangeUniqueIndex invoke() {
                    return new IntegerRangeUniqueIndex(0, this.this$0.getRowCount() - 1);
                }
            }));
            this.listener = new ColorMapListener(this){
                final /* synthetic */ ColorsDataFrame this$0;
                {
                    this.this$0 = $receiver;
                }

                public void colorMapChanged(@NotNull ColorMapEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    this.this$0.getRowIndexDelegate().forget();
                    ColorsDataFrame.access$notifyDataFrameChanged(this.this$0, new DataFrameEvent(null, null, true));
                }
            };
            this.colorMap.addWeakColorMapListener(this.listener);
        }

        @NotNull
        public DefaultUniqueIndex<String> getColumnIndex() {
            return this.columnIndex;
        }

        @NotNull
        public final Delegate<IntegerRangeUniqueIndex> getRowIndexDelegate() {
            return this.rowIndexDelegate;
        }

        @NotNull
        public IntegerRangeUniqueIndex getRowIndex() {
            return (IntegerRangeUniqueIndex)this.rowIndexDelegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        private static Object getRowIndex$delegate(ColorsDataFrame colorsDataFrame) {
            return colorsDataFrame.rowIndexDelegate;
        }

        @NotNull
        public final ColorMapListener getListener() {
            return this.listener;
        }

        public void setValueAt(int row, @NotNull String column, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            if (this.getColumnIndex().getAddress((Object)column) == 1) {
                Set set = this.colorMap.getAssignedValues();
                Intrinsics.checkNotNull((Object)set);
                Collection $this$toTypedArray$iv = set;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                this.colorMap.setColor(thisCollection$iv.toArray(new Object[0])[this.getRowIndex().getAddress(row)], (MkColor)value);
            }
        }

        @Nullable
        public KClass<?> getRowClass(int row) {
            return null;
        }

        @NotNull
        public KClass<? extends Object> getColumnClass(@NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            return switch (this.getColumnIndex().getAddress((Object)column)) {
                case 0 -> this.valueType;
                case 1 -> Reflection.getOrCreateKotlinClass(MkColor.class);
                default -> Reflection.getOrCreateKotlinClass(Object.class);
            };
        }

        @Nullable
        public Object getValueAt(int row, @NotNull String column) {
            Intrinsics.checkNotNullParameter((Object)column, (String)"column");
            int rowIndex = this.getRowIndex().getAddress(row);
            return switch (this.getColumnIndex().getAddress((Object)column)) {
                case 0 -> {
                    Set v0 = this.colorMap.getAssignedValues();
                    Intrinsics.checkNotNull((Object)v0);
                    Collection $this$toTypedArray$iv = v0;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    yield thisCollection$iv.toArray(new Object[0])[rowIndex];
                }
                case 1 -> {
                    Set v2 = this.colorMap.getAssignedValues();
                    Intrinsics.checkNotNull((Object)v2);
                    Collection $this$toTypedArray$iv = v2;
                    boolean $i$f$toTypedArray = false;
                    Collection thisCollection$iv = $this$toTypedArray$iv;
                    yield this.colorMap.getColor(thisCollection$iv.toArray(new Object[0])[rowIndex]);
                }
                default -> null;
            };
        }

        public int getRowCount() {
            Set set = this.colorMap.getAssignedValues();
            Intrinsics.checkNotNull((Object)set);
            return set.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public final boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1;
        }

        public static final /* synthetic */ void access$notifyDataFrameChanged(ColorsDataFrame $this, DataFrameEvent event) {
            $this.notifyDataFrameChanged(event);
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(ColorsDataFrame.class, "rowIndex", "getRowIndex()Lorg/molap/index/IntegerRangeUniqueIndex;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

