package com.macrofocus.visual

import com.macrofocus.common.filter.Filter
import com.macrofocus.common.filter.FilterEvent
import com.macrofocus.common.filter.FilterListener
import org.mkui.visual.VisualObjects

class FilteredVisualLayer<O>(visualObjects: VisualObjects<O>, filter: Filter<O>) : AbstractVisualLayer<O>() {
    private val visualObjects: VisualObjects<O>
    private val filter: Filter<O>
    private val filterListener: FilterListener<O> = object : FilterListener<O> {
        override fun filterChanged(event: FilterEvent<O>) {
            notifyVisualChanged()
        }
    }
    override val isActive: Boolean
        get() = filter.isActive

    override fun getObject(i: Int): O {
        return visualObjects.getObject(i)
    }

    override val objectCount: Int
        get() = if (filter.isActive) visualObjects.objectCount else 0

    override fun iterable(from: Int, to: Int): Iterable<O> {
        return object : ObjectsIterable<O>(this, from, to) {
            override fun condition(`object`: O): Boolean {
                return filter.isFiltered(`object`)
            }
        }
    }

    init {
        this.visualObjects = visualObjects
        this.filter = filter
        filter.addWeakFilterListener(filterListener)
    }
}