/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormapping;

import androidx.compose.runtime.internal.StabilityInferred;
import com.macrofocus.common.collection.SortedSet;
import com.macrofocus.common.collection.UniversalComparator;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.mkui.colormap.ColorMapFactory;
import org.mkui.colormap.MutableColorMap;
import org.molap.dataframe.DataFrame;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0004\n\u0002\b\u0005\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J[\u0010\u0003\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0005\"\u0004\b\u0001\u0010\u0006\"\u0004\b\u0002\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u0002H\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\u0002\u0010\u0010JA\u0010\u0011\u001a\u00020\u0004\"\u0004\b\u0000\u0010\u0006\"\u0004\b\u0001\u0010\u00072\u0006\u0010\b\u001a\u00020\t2\u0018\u0010\n\u001a\u0014\u0012\u0004\u0012\u0002H\u0006\u0012\u0004\u0012\u0002H\u0007\u0012\u0002\b\u0003\u0018\u00010\u000b2\u0006\u0010\f\u001a\u0002H\u0007\u00a2\u0006\u0002\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/macrofocus/colormapping/DataFrameColorMapFactory;", "", "()V", "createColorMap", "Lorg/mkui/colormap/MutableColorMap;", "Color", "R", "C", "factory", "Lorg/mkui/colormap/ColorMapFactory;", "dataFrame", "Lorg/molap/dataframe/DataFrame;", "column", "min", "", "max", "(Lorg/mkui/colormap/ColorMapFactory;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;Ljava/lang/Number;Ljava/lang/Number;)Lorg/mkui/colormap/MutableColorMap;", "createQualitativeColorMap", "(Lorg/mkui/colormap/ColorMapFactory;Lorg/molap/dataframe/DataFrame;Ljava/lang/Object;)Lorg/mkui/colormap/MutableColorMap;", "mkui-molap"})
@StabilityInferred(parameters=1)
public final class DataFrameColorMapFactory {
    @NotNull
    public static final DataFrameColorMapFactory INSTANCE = new DataFrameColorMapFactory();
    public static final int $stable;

    private DataFrameColorMapFactory() {
    }

    @NotNull
    public final <Color, R, C> MutableColorMap createColorMap(@NotNull ColorMapFactory factory, @Nullable DataFrame<R, C, ?> dataFrame, C column, @Nullable Number min, @Nullable Number max) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        return min != null && max != null ? factory.createAutoContinuousColorMap(min, max) : this.createQualitativeColorMap(factory, dataFrame, column);
    }

    @NotNull
    public final <R, C> MutableColorMap createQualitativeColorMap(@NotNull ColorMapFactory factory, @Nullable DataFrame<R, C, ?> dataFrame, C column) {
        MutableColorMap mutableColorMap;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        if (dataFrame != null && column != null) {
            Object value;
            Set values = (Set)new SortedSet((Comparator)new UniversalComparator(), null, 2, null);
            int valueCount = 0;
            for (Object row : dataFrame.rows()) {
                value = dataFrame.getValueAt(row, column);
                if (value == null || !(value instanceof Comparable)) continue;
                values.add(value);
                ++valueCount;
            }
            if (valueCount == 0) {
                values = new LinkedHashSet();
                for (Object row : dataFrame.rows()) {
                    value = dataFrame.getValueAt(row, column);
                    if (value == null) continue;
                    values.add(value);
                    ++valueCount;
                }
            }
            mutableColorMap = factory.createQualitativeColorMap(values);
        } else {
            mutableColorMap = factory.createQualitativeColorMap(SetsKt.emptySet());
        }
        return mutableColorMap;
    }
}

