package com.macrofocus.visual

import org.mkui.visual.VisualLayer
import org.mkui.visual.VisualListener

abstract class AbstractVisualLayer<O> : VisualLayer<O> {
    private val listeners: MutableList<VisualListener> = ArrayList<VisualListener>()
    override operator fun iterator(): Iterator<O> {
        return iterable(0, objectCount - 1).iterator()
    }

    protected abstract inner class ObjectsIterable<O>(visualLayer: VisualLayer<O>, from: Int, to: Int) : Iterable<O> {
        private val visualLayer: VisualLayer<O>
        private val from: Int
        private val to: Int
        override fun iterator(): Iterator<O> {
            return object : MutableIterator<O> {
                var index = from
                var nextEntry: O? = null
                var queryNext = true
                override fun hasNext(): Boolean {
                    if (queryNext) {
                        nextEntry = findNext()
                        queryNext = false
                    }
                    return nextEntry != null
                }

                override fun next(): O {
                    if (queryNext) {
                        nextEntry = findNext()
                    }
                    queryNext = true
                    return nextEntry!!
                }

                private fun findNext(): O? {
                    while (index <= to) {
                        val `object`: O = visualLayer.getObject(index)
                        if (condition(`object`)) {
                            index++
                            return `object`
                        }
                        index++
                    }
                    return null
                }

                override fun remove() {
                    throw UnsupportedOperationException()
                }
            }
        }

        abstract fun condition(`object`: O): Boolean

        init {
            this.visualLayer = visualLayer
            this.from = from
            this.to = to
        }
    }

    override fun addVisualListener(listener: VisualListener) {
        listeners.add(listener)
    }

    override fun removeVisualListener(listener: VisualListener) {
        listeners.remove(listener)
    }

    protected fun notifyVisualChanged() {
        for (listener in listeners) {
            listener.visualChanged()
        }
    }
}