/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.visual

import com.macrofocus.common.selection.Selection
import org.mkui.visual.VisualObjects

class AnnonatedVisualLayer<O>(visualObjects: VisualObjects<O>, annotation: Selection<O>) : AbstractVisualLayer<O>() {
    private val visualObjects: VisualObjects<O>
    private val annotation: Selection<O>
    override val isActive: Boolean
        get() = annotation.isActive

    override fun getObject(i: Int): O {
        return visualObjects.getObject(i)
    }

    override val objectCount: Int
        get() = visualObjects.objectCount

    override operator fun iterator(): Iterator<O> {
        return annotation.iterator()
    }

    override fun iterable(from: Int, to: Int): Iterable<O> {
        return object : ObjectsIterable<O>(this, from, to) {
            override fun condition(`object`: O): Boolean {
                return annotation.isSelected(`object`)
            }
        }
    }

    init {
        this.visualObjects = visualObjects
        this.annotation = annotation
    }
}