package com.macrofocus.visual

import com.macrofocus.common.filter.Filter
import com.macrofocus.common.filter.FilterEvent
import com.macrofocus.common.filter.FilterListener
import org.mkui.colormapping.ColorMapping
import org.mkui.colormapping.ColorMappingListener
import org.mkui.visual.VisualObjects

class ColorMappedVisualLayer<O,C>(visualObjects: VisualObjects<O>, filter: Filter<O>, colorMapping: ColorMapping<O, C>) : AbstractVisualLayer<O>() {
    private val visualObjects: VisualObjects<O>
    private val filter: Filter<O>
    private val colorMapping: ColorMapping<O, C>
    private val colorMappingListener: ColorMappingListener<O, C> = object : ColorMappingListener<O, C> {
        override fun colorMappingChanged() {
            notifyVisualChanged()
        }
    }
    private val filterListener: FilterListener<O> = object : FilterListener<O> {
        override fun filterChanged(event: FilterEvent<O>) {
            notifyVisualChanged()
        }
    }
    override val isActive: Boolean
        get() = colorMapping.isActive && visualObjects.objectCount > filter.filteredCount

    override fun getObject(i: Int): O {
        return visualObjects.getObject(i)
    }

    override val objectCount: Int
        get() = if (colorMapping.isActive) visualObjects.objectCount else 0

    override fun iterable(from: Int, to: Int): Iterable<O> {
        return object : ObjectsIterable<O>(this, from, to) {
            override fun condition(`object`: O): Boolean {
                return !filter.isFiltered(`object`)
            }
        }
    }

    init {
        this.visualObjects = visualObjects
        this.filter = filter
        this.colorMapping = colorMapping
        this.colorMapping.addWeakColormappingListener(colorMappingListener)
        filter.addWeakFilterListener(filterListener)
    }
}