package com.macrofocus.visual

import com.macrofocus.common.filter.Filter
import com.macrofocus.common.filter.FilterEvent
import com.macrofocus.common.filter.FilterListener
import org.mkui.coloring.Coloring
import org.mkui.coloring.ColoringListener
import org.mkui.coloring.implementation.ColoringEvent
import org.mkui.visual.VisualObjects

class ColoredVisualLayer<O>(visualObjects: VisualObjects<O>, filter: Filter<O>, coloring: Coloring<O>) : AbstractVisualLayer<O>() {
    private val visualObjects: VisualObjects<O>
    private val filter: Filter<O>
    private val coloring: Coloring<O>
    private val coloringListener: ColoringListener<O> = object : ColoringListener<O> {
        override fun coloringChanged(event: ColoringEvent<O>) {
            notifyVisualChanged()
        }
    }
    private val filterListener: FilterListener<O> = object : FilterListener<O> {
        override fun filterChanged(event: FilterEvent<O>) {
            notifyVisualChanged()
        }
    }
    override val isActive: Boolean
        get() = coloring.coloredCount > 0

    override fun getObject(i: Int): O {
        return visualObjects.getObject(i)
    }

    override val objectCount: Int
        get() = if (coloring.coloredCount > 0) visualObjects.objectCount else 0

    override fun iterable(from: Int, to: Int): Iterable<O> {
        return object : ObjectsIterable<O>(this, from, to) {
            override fun condition(`object`: O): Boolean {
                return !filter.isFiltered(`object`) && coloring.isColored(`object`)
            }
        }
    }

    init {
        this.visualObjects = visualObjects
        this.filter = filter
        this.coloring = coloring
        coloring.addWeakColoringListener(coloringListener)
        filter.addWeakFilterListener(filterListener)
    }
}