/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.visual

import org.mkui.visual.VisualObjects
import org.molap.dataframe.DataFrame

class SimpleVisualObjects<R>(dataFrame: DataFrame<R, *, *>) : VisualObjects<R> {
    private val dataFrame: DataFrame<R, *, *>
    override fun getObject(i: Int): R {
        return dataFrame.getRowKey(i)
    }

    override val objectCount: Int
        get() = dataFrame.rowCount

    init {
        this.dataFrame = dataFrame
    }
}