package org.mkui.colormap.editor

import com.macrofocus.common.properties.AbstractMutableProperty
import org.mkui.color.MkColor
import org.mkui.component.CPComponent
import org.mkui.component.CPFactory
import org.mkui.component.input.CPColorPicker
import org.mkui.table.Table
import org.molap.dataframe.MutableDataFrame

internal class ColorCellRenderer(
    factory: CPFactory,
    dataFrame: MutableDataFrame<Int, String, Any?>
) :
    Table.CellRenderer<Int, String, Any?> {
    private val factory: CPFactory = factory
    private val dataFrame: MutableDataFrame<Int, String, Any?> = dataFrame

    override fun render(component: CPComponent, row: Int, column: String, value: Any?): CPComponent {
        if (value != null) {
            val colorPicker: CPColorPicker = factory.createColorPicker(object : AbstractMutableProperty<MkColor?>() {
                override var value: MkColor?
                    get() = dataFrame.getValueAt(row, column) as MkColor?
                    set(value) {
                        dataFrame.setValueAt(row, column, value)
                    }
            })
            return colorPicker
        } else {
            return factory.createLabel("")
        }
    }
}
