package org.mkui.table

import com.macrofocus.common.properties.EnumProperties
import com.macrofocus.common.properties.MutableProperties
import com.macrofocus.common.properties.MutableProperty
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.graphics.colortheme.LightColorTheme

abstract class AbstractTable<R, C, V>() : Table<R, C, V> {
    protected val properties: MutableProperties<PropertyType> = EnumProperties<PropertyType>(PropertyType.values())

    var isSelectionMode: Boolean = true

    val locksmith: Any? = null

    init {
        properties.createProperty<Any>(PropertyType.InteractionMode, InteractionMode.Select)
        properties.createProperty<Any>(PropertyType.Style, Style.Border)
        properties.createProperty(PropertyType.ColorTheme, LightColorTheme())
    }

    override val interactionMode: MutableProperty<InteractionMode?>?
        get() = properties.getProperty(PropertyType.InteractionMode) as MutableProperty<InteractionMode?>?

    val style: MutableProperty<Any?>
        get() = properties.getProperty(PropertyType.Style)

    override var colorTheme: MutableProperty<ColorTheme>
        get() = properties.getProperty(PropertyType.ColorTheme) as MutableProperty<ColorTheme>
        set(colorTheme) {
            properties.replaceProperty(PropertyType.ColorTheme, colorTheme)
        }
}
