package org.mkui.table

import androidx.compose.material.Text
import androidx.compose.runtime.Composable
import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.properties.MutableProperty
import com.macrofocus.common.properties.SimpleProperty
import org.mkui.component.CPComponent
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.graphics.colortheme.LightColorTheme
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

class ComposeTable<R, C, V> constructor(
) : Table<R, C, V>, CPComponent {
    override val nativeComponent: @Composable () -> Unit = { Text("${this@ComposeTable::class}") }


    override fun setModel(dataFrame: DataFrame<R, C, V>?, visual: Visual<R, C>?) {
    }

    override var colorTheme: MutableProperty<ColorTheme> = SimpleProperty.newInstance(LightColorTheme())
    override fun setFrozenColumnCount(columnCount: Int) {
    }

    override fun setLabel(column: C, label: String?) {
    }

    override fun setFormat(column: C, format: CPFormat<*>?) {
    }

    override fun setSortKey(column: C?) {
    }

    override val interactionMode: MutableProperty<InteractionMode?>? = SimpleProperty.newInstance(null)
    override fun setColumnResizePolicy(policy: Table.ColumnResizePolicy?) {
    }

    override fun setPrefHeight(height: Double) {
    }

    override fun setEditable(editable: Boolean) {
    }

    override fun setColumnVisible(column: C, visible: Boolean) {
    }

    override fun setCellEditor(column: C, editor: Table.CellEditor<R, C, V>?) {
    }

    override fun setCellRenderer(column: C, renderer: Table.CellRenderer<R, C, V>?) {
    }
}