/*
 * Copyright (c) 2014 Macrofocus GmbH. All Rights Reserved.
 */
package com.macrofocus.colormapping

import com.macrofocus.common.collection.TreeSet
import com.macrofocus.common.collection.UniversalComparator
import org.mkui.colormap.ColorMapFactory
import org.mkui.colormap.MutableColorMap
import org.molap.dataframe.DataFrame

object DataFrameColorMapFactory {
    fun <Color, R, C> createColorMap(
        factory: ColorMapFactory,
        dataFrame: DataFrame<R, C, *>?,
        column: C,
        min: Number?,
        max: Number?
    ): MutableColorMap {
        return if (min != null && max != null) {
            factory.createAutoContinuousColorMap(min, max)
        } else {
            createQualitativeColorMap<R,C>(factory, dataFrame, column)
        }
    }

    fun <R, C> createQualitativeColorMap(factory: ColorMapFactory, dataFrame: DataFrame<R, C, *>?, column: C): MutableColorMap {
        return if (dataFrame != null && column != null) {
            var values: MutableSet<Any?> = TreeSet(UniversalComparator())
            var valueCount = 0
            for (row in dataFrame.rows()) {
                val value: Any? = dataFrame.getValueAt(row, column)
                if (value != null && value is Comparable<*>) {
                    values.add(value)
                    valueCount++
                }
            }

            // In case values are not comparable
            if (valueCount == 0) {
                values = LinkedHashSet()
                for (row in dataFrame.rows()) {
                    val value: Any? = dataFrame.getValueAt(row, column)
                    if (value != null) {
                        values.add(value)
                        valueCount++
                    }
                }
            }

            //            if (values.size() == valueCount) {
            //                // All values are unique
            //                return createSequentialColorMap(values);
            //            } else {
            factory.createQualitativeColorMap(values)
        } else {
            factory.createQualitativeColorMap(emptySet<Any?>())
        }
    }
}