package com.macrofocus.tooltip

import com.macrofocus.common.geom.Dimension
import org.mkui.color.MkColor
import org.mkui.color.colorOf
import org.mkui.geom.Point
import org.mkui.graphics.IGraphics
import org.mkui.graphics.Insets
import org.mkui.tooltip.Tooltip
import org.molap.dataframe.DataFrame

class DataFrameTooltip<Row,Column,Value>(dataFrame: DataFrame<Row, Column, Value>, val row: Row, override val desiredLocation: Point?) : Tooltip<Row> {
    val size = Dimension(0, 0)
    val insets = Insets(2, 2, 2, 2)
    val preferredWidth = 230
    val minimumHeight = 40
    val backgroundColor: MkColor = colorOf(232u, 232u, 232u, 200u)
    val borderColor: MkColor = colorOf(0u, 0u, 0u, 240u)

    override fun computePreferredSize(graphics: IGraphics): Dimension {
        return paint(graphics, row, false)
    }

    override fun paint(graphics: IGraphics, size: Dimension): Dimension {
        val x: Int = insets.left
        val y: Int = insets.top
        val drawableSize: Dimension = Dimension(size.iwidth - insets.left - insets.right, size.iheight - insets.top - insets.bottom)

        paintBackground(graphics, size)
        return drawableSize
    }

    fun paint(graphics: IGraphics, row: Row, paint: Boolean): Dimension {
        return Dimension(preferredWidth, minimumHeight)
    }

    fun paintBackground(g: IGraphics, size: Dimension) {
        g.setColor(backgroundColor)
        val x: Int = insets.left
        val y: Int = insets.top
        g.fillRectangle(x, y, size.iwidth, size.iheight)
//        g.fillRoundRect(x.toDouble(), y.toDouble(), width.toDouble(), height.toDouble(), 10.0, 10.0)
        //                g.setColor(background);
//                g.fillRect(0, 0, width, height);
        if (borderColor != null) {
            g.setColor(borderColor)
            val borderThickness: Float = insets.left.toFloat()
            g.setLineWidth(borderThickness.toDouble())
            val halfThickness = (borderThickness / 2).toDouble()
            g.drawRectange(
                halfThickness.toInt(),
                halfThickness.toInt(),
                size.iwidth, // - halfThickness
                size.iheight, // - halfThickness
            )
//            g.strokeRoundRect(
//                halfThickness,
//                halfThickness,
//                width.toDouble(), // - halfThickness
//                height.toDouble(), // - halfThickness
//                10.0,
//                10.0
//            )
        }
    }

    fun preferredSize(row: Row) {

    }
}