package com.macrofocus.visual

import com.macrofocus.common.selection.SingleSelection
import com.macrofocus.common.selection.SingleSelectionEvent
import com.macrofocus.common.selection.SingleSelectionListener
import org.mkui.visual.VisualObjects

class ProbedVisualLayer<O>(visualObjects: VisualObjects<O>?, selection: SingleSelection<O>) : AbstractVisualLayer<O>() {
    private val visualObjects: VisualObjects<O>?
    private val selection: SingleSelection<O>
    private val singleSelectionListener: SingleSelectionListener<O> = object : SingleSelectionListener<O> {
        override fun selectionChanged(event: SingleSelectionEvent<O>) {
            notifyVisualChanged()
        }
    }
    override val isActive: Boolean
        get() = selection.isActive

    override fun getObject(i: Int): O {
        return selection.selected!!
    }

    override val objectCount: Int
        get() = if (visualObjects != null && selection.isActive) selection.selectedCount else 0

    override operator fun iterator(): Iterator<O> {
        return selection.iterator()
    }

    override fun iterable(from: Int, to: Int): Iterable<O> {
        return object : ObjectsIterable<O>(this, from, to) {
            override fun condition(`object`: O): Boolean {
                return selection.isSelected(`object`)
            }
        }
    }

    init {
        this.visualObjects = visualObjects
        this.selection = selection
        selection.addWeakSingleSelectionListener(singleSelectionListener)
    }
}