package com.macrofocus.visual

import com.macrofocus.common.collection.Iterables
import com.macrofocus.common.filter.FilterEvent
import com.macrofocus.common.filter.FilterListener
import com.macrofocus.common.filter.MutableIndexFilter
import com.macrofocus.common.filter.SimpleIndexFilter
import com.macrofocus.common.selection.MutableSelection
import com.macrofocus.common.selection.MutableSingleSelection
import com.macrofocus.common.selection.SimpleSelection
import com.macrofocus.common.selection.SimpleSingleSelection
import org.mkui.coloring.MutableColoring
import org.mkui.coloring.implementation.SimpleColoring
import org.mkui.colormapping.MutableColorMapping
import org.mkui.visual.AbstractVisual
import org.mkui.visual.Visual
import org.mkui.visual.VisualLayer
import org.mkui.visual.VisualObjects

class SimpleVisual<O, C>(
    visualObjects: VisualObjects<O>,
    annotatedVisualObjects: VisualObjects<Any>?,
    probing: MutableSingleSelection<O>,
    selection: MutableSelection<O>,
    filter: MutableIndexFilter<O>,
    coloring: MutableColoring<O>,
    colorMapping: MutableColorMapping<O, C>,
    probingAnnotation: MutableSingleSelection<Any>,
    selectionAnnotation: MutableSelection<Any>
) : AbstractVisual<O, C>() {
    override val visualObjects: VisualObjects<O>
    override val probing: MutableSingleSelection<O>
    override val selection: MutableSelection<O>
    override val filter: MutableIndexFilter<O>
    override val colorMapping: MutableColorMapping<O, C>
    override val coloring: MutableColoring<O>
    private val probingAnnotation: MutableSingleSelection<Any>
    private val selectionAnnotation: MutableSelection<Any>
    override val filtered: VisualLayer<O>
    override val active: VisualLayer<O>
    override val visible: VisualLayer<O>
    override val colorMapped: VisualLayer<O>
    override val colored: VisualLayer<O>
    override val selected: VisualLayer<O>
    override val singleSelected: VisualLayer<O>
    override val multipleSelected: VisualLayer<O>
    override val probed: VisualLayer<O>
    private val probedAnnotated: VisualLayer<Any>
    private val selectedAnnotated: VisualLayer<Any>

    constructor(visualObjects: VisualObjects<O>, colorMapping: MutableColorMapping<O, C>) : this(
        visualObjects,
        null,
        SimpleSingleSelection<O>(),
        SimpleSelection<O>(),
        SimpleIndexFilter<O>(),
        SimpleColoring<O>(),
        colorMapping,
        SimpleSingleSelection<Any>(),
        SimpleSelection<Any>()
    ) {

        // ToDo: Move somewhere else? The logic is to place it with probing, selection, and filter are created.
        filter.addFilterListener(object : FilterListener<O> {
            override fun filterChanged(event: FilterEvent<O>) {
//                final MutableSingleSelection<O> probing = getProbing();
//                if (probing.isActive()) {
//                    O row = probing.getSelected();
//                    if (event.getAffected().contains(row) && getFilter().isFiltered(row)) {
//                        probing.setSelected(row, false);
//                    }
//                }
//
//                final MutableSelection<O> selection = getSelection();
//                if (selection.isActive()) {
//                    selection.setSelected(event.getFiltered(), false);
//                }

                // ToDo: Optimize by looking whether selecting or filter should be used first depending on their size
                if (selection.isActive && filter.isActive) {
                    selection.setSelectedIterableState(Iterables.conditional(selection, object : Iterables.Condition<O> {
                        override fun apply(var1: O): Boolean {
                            return filter.isFiltered(var1)
                        }
                    }), false)
                }
                if (probing.isActive && filter.isActive) {
                    if (filter.isFiltered(probing.selected!!)) {
                        probing.clearSelection()
                    }
                }
            }
        })
    }

    constructor(
        visualObjects: VisualObjects<O>,
        probing: MutableSingleSelection<O>,
        selection: MutableSelection<O>,
        colorMapping: MutableColorMapping<O, C>
    ) : this(
        visualObjects,
        null,
        probing,
        selection,
        SimpleIndexFilter<O>(),
        SimpleColoring<O>(),
        colorMapping,
        SimpleSingleSelection<Any>(),
        SimpleSelection<Any>()
    ) {
    }

    constructor(visual: Visual<O, *>, visualObjects: VisualObjects<O>, colorMapping: MutableColorMapping<O, C>) : this(
        visualObjects,
        null,
        visual.probing,
        visual.selection,
        visual.filter,
        visual.coloring,
        colorMapping,
        visual.annotationProbing,
        visual.annotationSelection
    ) {
    }

    override val annotationProbing: MutableSingleSelection<Any>
        get() = probingAnnotation
    override val annotationSelection: MutableSelection<Any>
        get() = selectionAnnotation


    override val probedAnnotation: VisualLayer<Any>
        get() = probedAnnotated
    override val selectedAnnotation: VisualLayer<Any>
        get() = selectedAnnotated

    init {
        this.visualObjects = visualObjects
        this.probing = probing
        this.selection = selection
        this.filter = filter
        this.coloring = coloring
        this.colorMapping = colorMapping
        this.probingAnnotation = probingAnnotation
        this.selectionAnnotation = selectionAnnotation
        filtered = FilteredVisualLayer<O>(visualObjects, filter)
        active = ActiveVisualLayer<O>(visualObjects, filter)
        visible = VisibleVisualLayer<O>(visualObjects, filter, colorMapping)
        colored = ColoredVisualLayer<O>(visualObjects, filter, coloring)
        colorMapped = ColorMappedVisualLayer<O,C>(visualObjects, filter, colorMapping)
        selected = SelectedVisualLayer<O>(visualObjects, selection, probing, filter)
        singleSelected = object : SelectedVisualLayer<O>(visualObjects, selection, probing, filter) {
            override val isActive: Boolean
                get() = selection.selectedCount == 1
        }
        multipleSelected = object : SelectedVisualLayer<O>(visualObjects, selection, probing, filter) {
            override val isActive: Boolean
                get() = selection.selectedCount > 1
        }
        probed = ProbedVisualLayer<O>(visualObjects, probing)
        probedAnnotated = ProbedVisualLayer<Any>(annotatedVisualObjects, probingAnnotation)
        selectedAnnotated = SelectedVisualLayer<Any>(annotatedVisualObjects, selectionAnnotation, probingAnnotation, null)
        //        annonated = new AnnonatedVisualLayer(new VisualObjects() {
//            @Override
//            public Object getObject(int i) {
//                return (O)annotation.getSelectedSet().toArray()[i];
//            }
//
//            @Override
//            public int getObjectCount() {
//                return annotation.getSelectedCount();
//            }
//        }, annotation);
    }
}