package com.macrofocus.visual

import com.macrofocus.common.filter.Filter
import com.macrofocus.common.filter.FilterEvent
import com.macrofocus.common.filter.FilterListener
import org.mkui.colormapping.ColorMapping
import org.mkui.visual.VisualObjects

class VisibleVisualLayer<O>(visualObjects: VisualObjects<O>, filter: Filter<O>, colorMapping: ColorMapping<O, *>) : AbstractVisualLayer<O>() {
    private val visualObjects: VisualObjects<O>
    private val filter: Filter<O>
    private val colorMapping: ColorMapping<O, *>
    private val filterListener: FilterListener<O> = object : FilterListener<O> {
        override fun filterChanged(event: FilterEvent<O>) {
            notifyVisualChanged()
        }
    }
    override val isActive: Boolean
        get() = !colorMapping.isActive && visualObjects.objectCount > filter.filteredCount

    override fun getObject(i: Int): O {
        return visualObjects.getObject(i)
    }

    override val objectCount: Int
        get() = if (colorMapping.isActive) 0 else visualObjects.objectCount

    override fun iterable(from: Int, to: Int): Iterable<O> {
        return object : ObjectsIterable<O>(this, from, to) {
            override fun condition(`object`: O): Boolean {
                return !filter.isFiltered(`object`)
            }
        }
    }

    init {
        this.visualObjects = visualObjects
        this.filter = filter
        this.colorMapping = colorMapping
        filter.addWeakFilterListener(filterListener)
    }
}