package org.mkui.colormap.editor

import org.mkui.colormap.ColorMapFactory
import org.mkui.component.CPFactory
import org.mkui.palette.PaletteFactory
import org.mkui.table.DefaultTableFactory

class CPColorMapEditorFactory private constructor() : ColorMapEditorFactory {
    override fun <C> createColorMapPanel(): ColorMapPanel<C> {
        val colorMapFactory = ColorMapFactory(PaletteFactory.instance)
        val tableFactory = DefaultTableFactory
        return CPColorMapPanel<C>(CPFactory.instance,
            CPCategoricalColorMapEditor(CPFactory.instance, colorMapFactory, tableFactory), CPPredefinedColorMapEditor(CPFactory.instance, colorMapFactory), CPCustomColorMapEditor(CPFactory.instance, colorMapFactory,
                tableFactory
            ))
    }

    companion object {
        val instance: CPColorMapEditorFactory = CPColorMapEditorFactory()
    }
}