package org.mkui.table

import com.macrofocus.common.format.CPFormat
import com.macrofocus.common.properties.MutableProperty
import org.mkui.component.CPComponent
import org.mkui.graphics.colortheme.ColorTheme
import org.mkui.visual.Visual
import org.molap.dataframe.DataFrame

interface Table<R, C, V> : CPComponent {
    enum class ColumnResizePolicy {
        Constrained, Unconstrained
    }

    fun setModel(dataFrame: DataFrame<R, C, V>?, visual: Visual<R, C>?)

    /**
     * Returns the color theme to use.
     *
     * @return the color theme
     */
    /**
     * Sets the color theme to use.
     *
     * @param colorTheme the color theme to use
     */
    var colorTheme: MutableProperty<ColorTheme>

    fun setSortKey(column: C?)

    fun setFormat(column: C, format: CPFormat<*>?)

    fun setLabel(column: C, label: String?)

    fun setFrozenColumnCount(columnCount: Int)

    val interactionMode: MutableProperty<InteractionMode?>?

    fun setColumnResizePolicy(policy: ColumnResizePolicy?)

    fun setPrefHeight(height: Double)

    fun setCellRenderer(column: C, renderer: CellRenderer<R, C, V>?)

    fun setCellEditor(column: C, editor: CellEditor<R, C, V>?)

    fun setEditable(editable: Boolean)

    interface CellRenderer<R, C, V> {
        fun render(component: CPComponent, row: R, column: C, value: V): CPComponent?
    }

    interface CellEditor<R, C, V> {
        fun isEditable(row: R, column: C, value: V): Boolean

        val format: CPFormat<V>?
    }

    fun setColumnVisible(column: C, visible: Boolean)
}
